\name{SmoothNormals}
\alias{SmoothNormals}
\title{Smooths calibration profiles}
\description{Smooths calibration profiles to remove noise. Uses a Loess smoother. 
This is a necessary step before applying the CorrectTumors function. 
}
\usage{
SmoothNormals(CGHNormal, bandwidth = 1)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{CGHNormal}{Matrix containing 3 or 4 probe information columns, followed by the calibration data for each normal profile}
  \item{bandwidth}{Bandwidth in MegaBase to be used for smoothing.}
}
\details{
Smooths calibration profiles to remove noise. Uses a Loess smoother as introduced by Marioni et al. (2009). 
Imputation (impute.knn) is automatically applied when missings are detected. SmoothNormals is a necessary step before applying the CorrectTumors function. 
}
\value{Matrix of the same dimensions as the input matrix containing the smoothed values
}
\references{Marioni, J.C., N.P. Thorne, A. Valsesia, T. Fitzgerald, R. Redon, H. Fiegler, T.D.
Andrews, B.E. Stranger, A.G. Lynch, E.T. Dermitzakis, N.P. Carter, S. Tavare,
and M.E. Hurles (2007). Breaking the waves: improved detection of copy number
variation from microarray-based comparative genomic hybridization. Genome Biol.,
8, R228.}
\author{Mark van de Wiel / John Marioni}

\seealso{\code{\link{CorrectTumors}}}
\examples{
data(pdatanorm)
NormalsSmooth <- SmoothNormals(pdatanorm, bandwidth = 1)
}

\keyword{smooth}
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line
