datacache <- new.env(hash=TRUE, parent=emptyenv())

FruitFlyAgilent <- function() showQCData("FruitFlyAgilent", datacache)
FruitFlyAgilent_dbconn <- function() dbconn(datacache)
FruitFlyAgilent_dbfile <- function() dbfile(datacache)
FruitFlyAgilent_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
FruitFlyAgilent_dbInfo <- function() dbInfo(datacache)

FruitFlyAgilentORGANISM <- "Drosophila melanogaster"

.onLoad <- function(libname, pkgname)
{
    require("methods", quietly=TRUE)
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "FruitFlyAgilent.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("FLYCHIP_DB", "FruitFlyAgilent", "chip FruitFlyAgilent", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(FruitFlyAgilent_dbconn())
}

