\name{microRNA.org2df.fun}
\alias{microRNA.org2df.fun}

\title{ Create a data frame of the links between transcripts and miRNAs }
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on the microRNA.org predictions, it creates a data frame representing the links between miRNAs and their target transcripts.
}
\usage{
microRNA.org2df.fun(file=NULL, url="http://cbio.mskcc.org/microrna_data/mouse_predictions_sept2008.txt.gz",
                    col.old=c("Gene.ID", "miRNA"), col.new=c("tran", "mir"))
}

\arguments{
  \item{file}{ A local file downloaded from microRNA.org }
  \item{url}{ A web address of microRNA.org }
  \item{slim}{ Logical, if TRUE (default), the result data frame will have just have two columns for transcript and miRNA; 
  if FALSE, the full table will be returned so that further manipulation can be done. }
  \item{col.old}{ A character vector of columns you want to extract from the original table as transcript and miRNA. }
  \item{col.new}{ A character vector of columns names you want to have in the result.}
}

\value{
A data frame, first column is "tran" and second column is "mir" so every row represents a link between one transcript and one miRNA.
If "slim=FASLE", the whole table with the original column names will be returned.  
}
\author{
Xikun Wu and Michael Watson
}
\seealso{ BioMart2df.fun, GEO2df.fun, GO2df.fun, KEGG2df.fun, miRBase2df.fun, sam.probe.fun }
\examples{
# they are equivalent  
tran2mir.df <- microRNA.org2df.fun(file="mouse_predictions_sept2008.txt")
tran2mir.df <- microRNA.org2df.fun(file="mouse_predictions_sept2008.txt.gz")
tran2mir.df <- microRNA.org2df.fun(url="http://cbio.mskcc.org/microrna_data/mouse_predictions_sept2008.txt.gz")
}

\keyword{ manip }