\name{corna.map.fun}
\alias{corna.map.fun}

\title{Map two columns of data frames or vectors}
\description{
Suppose there are two data frames or character vectors, x and y, having a common column, corna.map.fun maps x and y by 
the common column in a flexible way: 
1. if both x and y are vectors, the result will be a vector of the common elements.
2. if x is a data frame and y is a vector, a column name (m) of x need to be supplied so that y is linked to that column 
and the result will be a vector of the common elements in y and column m of x; if another column (n) in x is also supplied, 
the result will be a vector of the elements in n which link to y; if "all" is set to be TRUE, the result will be the 
data frame contains m, n of x and other columns of y if it is a data frame.   
3. if both x and y are data frames, they need to have at least one common column, m and n can be supplied as the columns 
of x and y which will be kept in the result; everything excepted the common column will be kept if m and n are not 
supplied; if "all" is set to be TRUE, the result will be the same as the merged result of x and y.
}
\usage{ corna.map.fun(x, y, m, n, all=FALSE) }

\arguments{
  \item{x}{ A data frame or character vector. }
  \item{y}{ A data frame or character vector. }
  \item{m}{ Name of the column in x tha. }
  \item{n}{ Name of column in x (e.g. c2). }
  \item{all}{ Logical, if FALSE (default), only the specified columns or vector is returned; if TRUE, whole mapped 
              data frame is returned.}
}

\value{ A character vector or a data frame. }

\author{
Xikun Wu and Michael Watson
}

\seealso{ merge }
\examples{
x <- data.frame(g=c("g1", "g1", "g2", "g3", "g4"),
                m=c("m1", "m2", "m3", "m3", "m3"))
y <- data.frame(g=c("g1", "g1", "g1", "g2", "g5"),
                p=c("p1", "p1", "p2", "p2", "p3"))
z <- c("g1", "g2", "g3")

corna.map.fun(x, y) 
#    m  p
# 1 m1 p1
# 2 m1 p2
# 3 m2 p1
# 4 m2 p2
# 5 m3 p2
corna.map.fun(x, y, all=TRUE) 
#    g  m  p
# 1 g1 m1 p1
# 2 g1 m1 p1
# 3 g1 m1 p2
# 4 g1 m2 p1
# 5 g1 m2 p1
# 6 g1 m2 p2
# 7 g2 m3 p2

corna.map.fun(x, z, "g", "m")
# [1] "m1" "m2" "m3"
corna.map.fun(x, z, "g", "m", all=TRUE)
#    g  m
# 1 g1 m1
# 2 g1 m2
# 3 g2 m3
# 4 g3 m3
}

\keyword{ manip }

