\name{GO2df.fun}
\alias{GO2df.fun}

\title{ Create data frame of the links between GO id and GO term }
\description{
One of the 7 functions prepares the required data objects of the CORNA package.
Based on resource of NCBI (gene2go), this function creates data frame of the links between GO id and GO term.
}
\usage{
GO2df.fun(file=NULL, url="ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/gene2go.gz", col.new = c("goid", "term"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file}{ A local file downloaded from NCBI. }
  \item{url}{ Web address of "gene2go" of NCBI. }
  \item{col.new}{ A character vector of the column names of the result. }
}

\value{
A data frame, first column is the GO id and the second column is the GO term.
}
\author{
Xikun Wu and Michael Watson
}
\seealso{ BioMart2df.fun, GEO2df.fun, KEGG2df.fun, microRNA.org2df.fun, miRBase2df.fun, sam.probe.fun }
\examples{
# they are equivalent   
go2term.df <- GO2df.fun(file="gene2go")
go2term.df <- GO2df.fun(file="gene2go.gz")
go2term.df <- GO2df.fun(url="ftp://ftp.ncbi.nlm.nih.gov/gene/DATA/gene2go.gz")
}

\keyword{ manip }
