`microRNA.org2df.fun` <-
function(file=NULL, url=NULL, slim=TRUE,
                                col.old=c("Gene.ID", "miRNA"),
                                col.new=c("tran", "mir")){
  file <- getfile.fun(file=file, url=url)
  d <- read.table(file, header=TRUE, sep="\t", stringsAsFactor=FALSE)
  if(slim==TRUE){
    d <- unique(d[, col.old])
    d[, "miRNA"] <-  tolower(gsub("\\*","", d[, "miRNA"]))
    for(r in col.old){
      d <- d[d[, r]!="", ]
    }
    d <- na.omit(d)
    rownames(d) <- c(1:nrow(d)) 
    colnames(d) <- col.new
  }
  return(d)
}

