`miRBase2df.fun` <-
function(file=NULL, url=NULL, slim=TRUE,
                           col.old=c("TRANSCRIPT_ID", "SEQ"),
                           col.new=c("tran", "mir")){
  file <- getfile.fun(file=file, url=url)
  d <- read.table(file, skip=5, sep="\t", stringsAsFactor=FALSE)
  colnames(d) <- c("GROUP","SEQ","METHOD","FEATURE","CHR", "START","END","STRAND",
                   "PHASE","SCORE","PVALUE_OG","TRANSCRIPT_ID","EXTERNAL_NAM")
  if(slim==TRUE){
    d[, "SEQ"] <-  tolower(gsub("\\*","", d[, "SEQ"]))
    d <- unique(d[, col.old])
    for(r in col.old){
      d <- d[d[, r]!="", ]
    }
    d <- na.omit(d)
    rownames(d) <- c(1:nrow(d)) 
    colnames(d) <- col.new
  }
  return(d)
}

