`corna.line.fun` <-
function(x, scale.data=T,
         array.order=c(1:ncol(x)), probe.colour=NULL,  
         array.line=T, array.colour=rep("black", length(array.order)),
         las=1, ps=13, mar=c(7,3,3,1),
         type="l", xlab="", ylab="", asp="", main="CORNA lines", sub="",
         my.axis.1=axis(1, at=0:(n-1), lab=colnames(d), adj=0.5, cex.axis=0.8, col="black", tick=T),
         my.axis.2=axis(2, at=0:0, lab=0, adj=0, cex.axis=1, col="black", tick=T),
         my.axis.3="",
         my.axis.4=""){ 
  d <- na.omit(x[, array.order])
  n <- ncol(d)
  if(is.null(probe.colour)) {probe.colour <- rainbow(nrow(d))}                                        
  if(scale.data==T){d[, 1:n] <- t(scale(t(d[, 1:n])))} 
  par(las=las, ps=ps, mar=mar)
  plot(c(0:(n-1)),d[1,1:n],col=probe.colour[1],ylim=range(d[,1:n]),type=type,ylab=ylab,xlab=xlab,xaxt="n",asp=asp,main=main,sub=sub)
  my.axis.1
  my.axis.2
  my.axis.3
  my.axis.4
  if(array.line==T){for(i in 0:(n-1)){lines(c(i,i), range(d[,1:n]), col=array.colour[i+1], type="l")}}
  for(i in 2:nrow(d)){lines(c(0:(n-1)), d[i,1:n], col=probe.colour[i], type=type)}
}
