`KEGG2df.fun` <-
function(kegg2gene.file=NULL, kegg2gene.url=NULL, 
         kegg2path.file=NULL, kegg2path.url=NULL, 
         path2name.file=NULL, path2name.url=NULL, 
         org=NULL, col.new=c("gene", "path", "name")){
  if(!is.null(org)){
    url <- paste("ftp://ftp.genome.jp/pub/kegg/genes/organisms/", org, "/", org, "_", sep="")
    if(is.null(kegg2gene.file) && is.null(kegg2gene.url)){
      kegg2gene.url <- paste(url, "ensembl-", org, ".list", sep="")
    }
    if(is.null(kegg2path.file) && is.null(kegg2path.url)){
      kegg2path.url <- paste(url, "pathway.list", sep="")
    }
  }
  if(is.null(path2name.file) && is.null(path2name.url)){
    path2name.url <- "ftp://ftp.genome.jp/pub/kegg/pathway/map_title.tab"
  }
  if(is.null(org)){
    if(!is.null(kegg2gene.url)){
      v <- strsplit(kegg2gene.url, "/")[[1]]
    }
    else{
      v <- strsplit(kegg2gene.file, "/")[[1]]
    }
    org <- strsplit(v[length(v)], "_")[[1]][1]
  }
  
  k2g.file   <- getfile.fun(file=kegg2gene.file, url=kegg2gene.url)
  k2g.df     <- read.table(k2g.file)
  k2g.df[,1] <- sub(paste(org, ":", sep=""), "", k2g.df[,1])
  k2g.df[,2] <- sub(paste("ensembl-", org, ":", sep=""), "", k2g.df[,2])
    
  k2p.file   <- getfile.fun(file=kegg2path.file, url=kegg2path.url)
  k2p.df     <- read.table(k2p.file)
  k2p.df[,1] <- sub(paste(org, ":", sep=""), "", k2p.df[,1])
  k2p.df[,2] <- sub(paste("path:", org, sep=""), "", k2p.df[,2])
  
  p2n.file   <- getfile.fun(file=path2name.file, url=path2name.url)
  p2n.line   <- readLines(p2n.file, n=-1)                            
  p2n.vec    <- strsplit(p2n.line, "\t")                                
  p2n.df     <- data.frame(V1=sapply(p2n.vec, '[', 1)) 
  for(i in 2:length(p2n.vec[[1]])){                           
    p2n.df[, i] <- sapply(p2n.vec, '[', i)                         
  }  
  
  colnames(k2g.df) <- c("k", "g")
  colnames(k2p.df) <- c("k", "p")
  colnames(p2n.df) <- c("p", "n")
   
  d.df  <- merge(k2p.df, k2g.df, sort=F)
  d.df  <- merge(d.df, p2n.df, sort=F)
  d.df  <- unique(d.df[c("g", "p", "n")]) 
  rownames(d.df) <- c(1:nrow(d.df)) 
  colnames(d.df) <- col.new  
  return(d.df) 
}
