`GEO2df.fun` <-
function(file=NULL, url=NULL, string=NULL){
  if(!is.null(file) || !is.null(url)){                        
    file <- getfile.fun(file=file, url=url)
    geo <- getGEO(filename=file)            # read GEO object from file
  }
  else{                                     # when file and url are both undefined
    if(!is.null(string)){                   # read GEO object from string
      geo <- getGEO(GEO=string)
    }
    else{                                   # report error if string is also undefined
      stop("Please supply a filename of a GEO file, or the url of downloading it or a GEO accession")
    }
  }
  
  # make microarray data frame from GEO object
  probes <- Table(GPLList(geo)[[1]])$ID
  mat    <- do.call("cbind", lapply(GSMList(geo),
                    function(x){
                      tab <- Table(x)
                      mymatch <- match(probes, tab$ID_REF)
                      return(tab$VALUE[mymatch])
                    }))
  mat[is.na(mat)] <- 0                    # set NA's as 0s
  mat[mat <= 0]   <- 0.5                  # set negatives and 0s to small value
  genes           <- Table(geo@gpls[[1]]) # get the genes

  # define data type, row names and column names of the microarry matrix
  data.frame(matrix(as.numeric(mat), nrow=nrow(mat), ncol=ncol(mat),
                    dimnames=list(genes$ID, colnames(mat))))
}

