/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDir
implements Vfs.Dir {
    final java.util.zip.ZipFile zipFile;
    private String path;

    public ZipDir(URL url) {
        this(Vfs.normalizePath(url));
    }

    public ZipDir(String path) {
        java.util.zip.ZipFile result;
        this.path = path;
        try {
            result = new java.util.zip.ZipFile(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.zipFile = result;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Iterable<Vfs.File> getFiles() {
        return new Iterable<Vfs.File>(){

            @Override
            public Iterator<Vfs.File> iterator() {
                return new AbstractIterator<Vfs.File>(){
                    final Enumeration<? extends ZipEntry> entries;
                    {
                        this.entries = ZipDir.this.zipFile.entries();
                    }

                    @Override
                    protected Vfs.File computeNext() {
                        return this.entries.hasMoreElements() ? new ZipFile(ZipDir.this, this.entries.nextElement()) : (Vfs.File)this.endOfData();
                    }
                };
            }
        };
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException("could not close zip file " + this.path, e);
            }
        }
    }

    public String toString() {
        return this.zipFile.getName();
    }
}

