/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
public class VariantsToTable
extends RodWalker<Integer, Integer> {
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which results should be written", required=true)
    protected PrintStream out;
    @Argument(fullName="fields", shortName="F", doc="The name of each field to capture for output in the table", required=false)
    public List<String> fieldsToTake = new ArrayList<String>();
    @Argument(fullName="genotypeFields", shortName="GF", doc="The name of each genotype field to capture for output in the table", required=false)
    public List<String> genotypeFieldsToTake = new ArrayList<String>();
    @Advanced
    @Argument(fullName="showFiltered", shortName="raw", doc="If provided, field values from filtered records will be included in the output", required=false)
    public boolean showFiltered = false;
    @Argument(fullName="maxRecords", shortName="M", doc="If provided, we will emit at most maxRecord records to the table", required=false)
    public int MAX_RECORDS = -1;
    long nRecords = 0L;
    @Argument(fullName="splitMultiAllelic", shortName="SMA", doc="If provided, we will split multi-allelic records into multiple lines of output", required=false)
    public boolean splitMultiAllelic = false;
    @Advanced
    @Argument(fullName="moltenize", shortName="moltenize", doc="If provided, we will produce molten output", required=false)
    public boolean moltenizeOutput = false;
    @Advanced
    @Argument(fullName="allowMissingData", shortName="AMD", doc="If provided, we will not require every record to contain every field", required=false)
    public boolean ALLOW_MISSING_DATA = false;
    private static final String MISSING_DATA = "NA";
    private final List<String> samples = new ArrayList<String>();
    public static final Map<String, Getter> getters = new HashMap<String, Getter>();

    @Override
    public void initialize() {
        if (!this.genotypeFieldsToTake.isEmpty()) {
            Map<String, VCFHeader> vcfRods = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), this.variants);
            TreeSet<String> vcfSamples = new TreeSet<String>(SampleUtils.getSampleList(vcfRods, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE));
            this.samples.addAll(vcfSamples);
            if (this.samples.isEmpty()) {
                this.genotypeFieldsToTake.clear();
            }
        }
        if (this.moltenizeOutput) {
            this.out.println("RecordID\tSample\tVariable\tValue");
        } else {
            String baseHeader = Utils.join("\t", this.fieldsToTake);
            String genotypeHeader = VariantsToTable.createGenotypeHeader(this.genotypeFieldsToTake, this.samples);
            String separator = !baseHeader.isEmpty() && !genotypeHeader.isEmpty() ? "\t" : "";
            this.out.println(baseHeader + separator + genotypeHeader);
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        for (VariantContext vc : tracker.getValues(this.variants, context.getLocation())) {
            if (!this.showFiltered && !vc.isNotFiltered()) continue;
            ++this.nRecords;
            for (List<String> record : VariantsToTable.extractFields(vc, this.fieldsToTake, this.genotypeFieldsToTake, this.samples, this.ALLOW_MISSING_DATA, this.splitMultiAllelic)) {
                if (this.moltenizeOutput) {
                    this.emitMoltenizedOutput(record);
                    continue;
                }
                this.out.println(Utils.join("\t", record));
            }
        }
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.MAX_RECORDS != -1 && this.nRecords >= (long)this.MAX_RECORDS;
    }

    private static final boolean isWildCard(String s) {
        return s.endsWith("*");
    }

    private static String createGenotypeHeader(List<String> genotypeFieldsToTake, List<String> samples) {
        boolean firstEntry = true;
        StringBuilder sb = new StringBuilder();
        for (String sample : samples) {
            for (String gf : genotypeFieldsToTake) {
                if (firstEntry) {
                    firstEntry = false;
                } else {
                    sb.append("\t");
                }
                sb.append(sample.replace(" ", "_"));
                sb.append(".");
                sb.append(gf);
            }
        }
        return sb.toString();
    }

    private void emitMoltenizedOutput(List<String> record) {
        int index = 0;
        for (String field : this.fieldsToTake) {
            this.out.println(String.format("%d\tsite\t%s\t%s", this.nRecords, field, record.get(index++)));
        }
        for (String sample : this.samples) {
            for (String gf : this.genotypeFieldsToTake) {
                this.out.println(String.format("%d\t%s\t%s\t%s", this.nRecords, sample.replace(" ", "_"), gf, record.get(index++)));
            }
        }
    }

    private static List<List<String>> extractFields(VariantContext vc, List<String> fields, List<String> genotypeFields, List<String> samples, boolean allowMissingData, boolean splitMultiAllelic) {
        boolean addGenotypeFields;
        int numRecordsToProduce = splitMultiAllelic ? vc.getAlternateAlleles().size() : 1;
        ArrayList<List<String>> records = new ArrayList<List<String>>(numRecordsToProduce);
        int numFields = fields.size();
        boolean bl = addGenotypeFields = genotypeFields != null && !genotypeFields.isEmpty();
        if (addGenotypeFields) {
            numFields += genotypeFields.size() * samples.size();
        }
        for (int i = 0; i < numRecordsToProduce; ++i) {
            records.add(new ArrayList(numFields));
        }
        for (String field : fields) {
            if (splitMultiAllelic && field.equals("ALT")) {
                VariantsToTable.addFieldValue(VariantsToTable.splitAltAlleles(vc), records);
                continue;
            }
            if (getters.containsKey(field)) {
                VariantsToTable.addFieldValue(getters.get(field).get(vc), records);
                continue;
            }
            if (vc.hasAttribute(field)) {
                VariantsToTable.addFieldValue(vc.getAttribute(field, null), records);
                continue;
            }
            if (VariantsToTable.isWildCard(field)) {
                HashSet<String> wildVals = new HashSet<String>();
                for (Map.Entry<String, Object> elt : vc.getAttributes().entrySet()) {
                    if (!elt.getKey().startsWith(field.substring(0, field.length() - 1))) continue;
                    wildVals.add(elt.getValue().toString());
                }
                String val = MISSING_DATA;
                if (wildVals.size() > 0) {
                    ArrayList toVal = new ArrayList(wildVals);
                    Collections.sort(toVal);
                    val = Utils.join(",", toVal);
                }
                VariantsToTable.addFieldValue(val, records);
                continue;
            }
            if (!allowMissingData) {
                throw new UserException(String.format("Missing field %s in vc %s at %s", field, vc.getSource(), vc));
            }
            VariantsToTable.addFieldValue(MISSING_DATA, records);
        }
        if (addGenotypeFields) {
            for (String sample : samples) {
                for (String gf : genotypeFields) {
                    if (vc.hasGenotype(sample) && vc.getGenotype(sample).hasAnyAttribute(gf)) {
                        if (gf.equals("GT")) {
                            VariantsToTable.addFieldValue(vc.getGenotype(sample).getGenotypeString(true), records);
                            continue;
                        }
                        VariantsToTable.addFieldValue(vc.getGenotype(sample).getAnyAttribute(gf), records);
                        continue;
                    }
                    VariantsToTable.addFieldValue(MISSING_DATA, records);
                }
            }
        }
        return records;
    }

    private static void addFieldValue(Object val, List<List<String>> result) {
        int numResultRecords = result.size();
        if (numResultRecords == 1) {
            result.get(0).add(val.toString());
        } else if (val instanceof List && ((List)val).size() == numResultRecords) {
            List list = (List)val;
            for (int i = 0; i < numResultRecords; ++i) {
                result.get(i).add(list.get(i).toString());
            }
        } else {
            String valStr = val.toString();
            for (List<String> record : result) {
                record.add(valStr);
            }
        }
    }

    public static List<List<String>> extractFields(VariantContext vc, List<String> fields, boolean allowMissingData) {
        return VariantsToTable.extractFields(vc, fields, null, null, allowMissingData, false);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }

    private static Object splitAltAlleles(VariantContext vc) {
        int numAltAlleles = vc.getAlternateAlleles().size();
        if (numAltAlleles == 1) {
            return vc.getAlternateAllele(0);
        }
        return vc.getAlternateAlleles();
    }

    static {
        getters.put("CHROM", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getChr();
            }
        });
        getters.put("POS", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getStart());
            }
        });
        getters.put("REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                StringBuilder x = new StringBuilder();
                x.append(vc.getReference().getDisplayString());
                return x.toString();
            }
        });
        getters.put("ALT", new Getter(){

            @Override
            public String get(VariantContext vc) {
                StringBuilder x = new StringBuilder();
                int n = vc.getAlternateAlleles().size();
                if (n == 0) {
                    return ".";
                }
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        x.append(",");
                    }
                    x.append(vc.getAlternateAllele(i));
                }
                return x.toString();
            }
        });
        getters.put("EVENTLENGTH", new Getter(){

            @Override
            public String get(VariantContext vc) {
                int maxLength = 0;
                for (Allele a : vc.getAlternateAlleles()) {
                    int length = a.length() - vc.getReference().length();
                    if (Math.abs(length) <= Math.abs(maxLength)) continue;
                    maxLength = length;
                }
                return Integer.toString(maxLength);
            }
        });
        getters.put("QUAL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Double.toString(vc.getPhredScaledQual());
            }
        });
        getters.put("TRANSITION", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.isSNP() && vc.isBiallelic()) {
                    return VariantContextUtils.isTransition(vc) ? "1" : "0";
                }
                return "-1";
            }
        });
        getters.put("FILTER", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.isNotFiltered() ? "PASS" : Utils.join(",", vc.getFilters());
            }
        });
        getters.put("ID", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getID();
            }
        });
        getters.put("HET", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount());
            }
        });
        getters.put("HOM-REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomRefCount());
            }
        });
        getters.put("HOM-VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomVarCount());
            }
        });
        getters.put("NO-CALL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNoCallCount());
            }
        });
        getters.put("TYPE", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getType().toString();
            }
        });
        getters.put("VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount() + vc.getHomVarCount());
            }
        });
        getters.put("NSAMPLES", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples());
            }
        });
        getters.put("NCALLED", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples() - vc.getNoCallCount());
            }
        });
        getters.put("MULTI-ALLELIC", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Boolean.toString(vc.getAlternateAlleles().size() > 1);
            }
        });
        getters.put("GQ", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.getNSamples() > 1) {
                    throw new UserException("Cannot get GQ values for multi-sample VCF");
                }
                return String.format("%.2f", -10.0 * vc.getGenotype(0).getLog10PError());
            }
        });
    }

    public static abstract class Getter {
        public abstract String get(VariantContext var1);
    }
}

