/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.StratNode;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.manager.Stratifier;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class StratificationManager<K extends Stratifier, V>
implements Map<List<Object>, V> {
    private final StratNode<K> root;
    private final int size;
    private final ArrayList<K> stratifiers;
    private final ArrayList<V> valuesByKey;
    private final ArrayList<List<Object>> stratifierValuesByKey;
    private final ArrayList<String> keyStrings;

    @Requires(value={"!strats.isEmpty()"})
    public StratificationManager(List<K> strats) {
        this.stratifiers = new ArrayList<K>(strats);
        this.root = this.buildStratificationTree(new LinkedList<K>(strats));
        this.assignKeys(this.root);
        this.size = this.root.size();
        if (this.size == 0) {
            throw new ReviewedStingException("Size == 0 in StratificationManager");
        }
        this.valuesByKey = new ArrayList(this.size());
        this.stratifierValuesByKey = new ArrayList(this.size());
        this.keyStrings = new ArrayList(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.valuesByKey.add(null);
            this.stratifierValuesByKey.add(null);
            this.keyStrings.add(null);
        }
        this.assignStratifierValuesByKey(this.root);
    }

    private StratNode<K> buildStratificationTree(Queue<K> strats) {
        Stratifier first = (Stratifier)strats.poll();
        if (first == null) {
            return new StratNode();
        }
        List states = first.getAllStates();
        if (states.isEmpty()) {
            throw new ReviewedStingException("State " + first + " is empty!");
        }
        LinkedHashMap subNodes = new LinkedHashMap(states.size());
        for (Object state : states) {
            LinkedList<K> copy = new LinkedList<K>(strats);
            subNodes.put(state, this.buildStratificationTree(copy));
        }
        return new StratNode<Stratifier>(first, subNodes);
    }

    @Requires(value={"root == this.root"})
    private void assignKeys(StratNode<K> root) {
        int key = 0;
        for (StratNode<K> node : root) {
            if (!node.isLeaf()) continue;
            node.setKey(key++);
        }
    }

    private void assignStratifierValuesByKey(StratNode<K> root) {
        this.assignStratifierValuesByKey(root, new LinkedList<Object>());
        for (List<Object> stateValues : this.stratifierValuesByKey) {
            if (stateValues != null) continue;
            throw new ReviewedStingException("Found a null state value set that's null");
        }
    }

    private void assignStratifierValuesByKey(StratNode<K> node, LinkedList<Object> states) {
        if (node.isLeaf()) {
            if (states.isEmpty()) {
                throw new ReviewedStingException("Found a leaf node with an empty state values vector");
            }
            this.stratifierValuesByKey.set(node.getKey(), Collections.unmodifiableList(new ArrayList<Object>(states)));
        } else {
            for (Map.Entry<Object, StratNode<K>> entry : node.getSubnodes().entrySet()) {
                LinkedList<Object> newStates = new LinkedList<Object>(states);
                newStates.addLast(entry.getKey());
                this.assignStratifierValuesByKey(entry.getValue(), newStates);
            }
        }
    }

    @Override
    @Ensures(value={"result >= 0"})
    public int size() {
        return this.size;
    }

    @Ensures(value={"result != null"})
    protected StratNode<K> getRoot() {
        return this.root;
    }

    @Ensures(value={"result != null"})
    public List<K> getStratifiers() {
        return this.stratifiers;
    }

    @Requires(value={"states != null"})
    @Ensures(value={"result >= -1"})
    public int getKey(List<Object> states) {
        return this.root.find(states, 0);
    }

    @Requires(value={"allStates != null"})
    @Ensures(value={"result != null"})
    public Set<Integer> getKeys(List<List<Object>> allStates) {
        HashSet<Integer> keys = new HashSet<Integer>();
        this.root.find(allStates, 0, keys);
        return keys;
    }

    public List<Object> getStatesForKey(int key) {
        ArrayList<Object> states = new ArrayList<Object>(this.stratifiers.size());
        for (int i = 0; i < this.stratifiers.size(); ++i) {
            Object stratValue = this.stratifierValuesByKey.get(key).get(i);
            states.add(stratValue);
        }
        return states;
    }

    public List<Pair<K, Object>> getStratsAndStatesForKey(int key) {
        ArrayList<Pair<K, Object>> states = new ArrayList<Pair<K, Object>>(this.stratifiers.size());
        for (int i = 0; i < this.stratifiers.size(); ++i) {
            Stratifier strat = (Stratifier)this.stratifiers.get(i);
            Object stratValue = this.stratifierValuesByKey.get(key).get(i);
            states.add(new Pair<Stratifier, Object>(strat, stratValue));
        }
        return states;
    }

    public String getStratsAndStatesStringForKey(int key) {
        if (this.keyStrings.get(key) == null) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < this.stratifiers.size(); ++i) {
                Stratifier strat = (Stratifier)this.stratifiers.get(i);
                Object stratValue = this.stratifierValuesByKey.get(key).get(i);
                b.append(strat.toString()).append(":").append(stratValue.toString());
            }
            this.keyStrings.set(key, b.toString());
        }
        return this.keyStrings.get(key);
    }

    @Override
    @Ensures(value={"result != null"})
    public ArrayList<V> values() {
        return this.valuesByKey;
    }

    public Collection<V> values(List<List<Object>> states) {
        LinkedList<V> vals = new LinkedList<V>();
        for (int key : this.getKeys(states)) {
            vals.add(this.get(key));
        }
        return vals;
    }

    @Requires(value={"key >= 0 && key <= size()"})
    @Ensures(value={"get(key) == value"})
    public void set(int key, V value) {
        this.valuesByKey.set(key, value);
    }

    @Requires(value={"key >= 0 && key <= size()"})
    public V get(int key) {
        return this.valuesByKey.get(key);
    }

    @Requires(value={"getKey(states) != -1"})
    public V get(List<Object> states) {
        return this.get(this.getKey(states));
    }

    @Override
    public V get(Object o) {
        return this.get((List)o);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean containsKey(List<Object> o) {
        return this.getKey(o) != -1;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.containsKey((List)o);
    }

    @Override
    public boolean containsValue(Object o) {
        throw new ReviewedStingException("containsValue() not implemented for StratificationManager");
    }

    @Override
    public V put(List<Object> objects, V v) {
        throw new ReviewedStingException("put() not implemented for StratificationManager");
    }

    @Override
    public V remove(Object o) {
        throw new ReviewedStingException("remove() not implemented for StratificationManager");
    }

    @Override
    public void putAll(Map<? extends List<Object>, ? extends V> map) {
        throw new ReviewedStingException("clear() not implemented for StratificationManager");
    }

    @Override
    public void clear() {
        throw new ReviewedStingException("clear() not implemented for StratificationManager");
    }

    @Override
    public Set<List<Object>> keySet() {
        throw new ReviewedStingException("Not yet implemented");
    }

    @Override
    public Set<Map.Entry<List<Object>, V>> entrySet() {
        throw new ReviewedStingException("Not yet implemented");
    }

    public static List<List<Object>> combineStates(List<Object> first, List<Object> second) {
        ArrayList<List<Object>> combined = new ArrayList<List<Object>>(first.size());
        for (int i = 0; i < first.size(); ++i) {
            Object secondI;
            Object firstI = first.get(i);
            if (firstI.equals(secondI = second.get(i))) {
                combined.add(Collections.singletonList(firstI));
                continue;
            }
            combined.add(Arrays.asList(firstI, secondI));
        }
        return combined;
    }

    public StratificationManager<K, V> combineStrats(K stratifierToReplace, K newStratifier, Combiner<V> combiner, Map<Object, Object> remappedStates) {
        if (!newStratifier.getAllStates().containsAll(remappedStates.values())) {
            throw new ReviewedStingException("combineStrats: remapped states contains states not found in newStratifer state set");
        }
        if (!remappedStates.keySet().containsAll(stratifierToReplace.getAllStates())) {
            throw new ReviewedStingException("combineStrats: remapped states missing mapping for some states");
        }
        ArrayList<K> newStrats = new ArrayList<K>(this.getStratifiers());
        int stratOffset = newStrats.indexOf(stratifierToReplace);
        if (stratOffset == -1) {
            throw new ReviewedStingException("Could not find strat to replace " + stratifierToReplace + " in existing strats " + newStrats);
        }
        newStrats.set(stratOffset, newStratifier);
        StratificationManager<K, V> combined = new StratificationManager<K, V>(newStrats);
        for (int key = 0; key < this.size(); ++key) {
            ArrayList<Object> newStates = new ArrayList<Object>(this.getStatesForKey(key));
            Object oldState = newStates.get(stratOffset);
            Object newState = remappedStates.get(oldState);
            newStates.set(stratOffset, newState);
            int combinedKey = combined.getKey(newStates);
            if (combinedKey == -1) {
                throw new ReviewedStingException("Couldn't find key for states: " + Utils.join(",", newStates));
            }
            V combinedValue = combiner.combine(combined.get(combinedKey), this.get(key));
            combined.set(combinedKey, combinedValue);
        }
        return combined;
    }

    public static interface Combiner<V> {
        public V combine(V var1, V var2);
    }
}

