/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation;

import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.IndelUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;
import org.broadinstitute.sting.utils.variantcontext.writer.VariantContextWriter;

@DocumentedGATKFeature(groupName="Validation Utilities", extraDocs={CommandLineGATK.class})
@Requires(value={DataSource.READS, DataSource.REFERENCE})
@Allows(value={DataSource.READS, DataSource.REFERENCE})
@By(value=DataSource.REFERENCE)
@Reference(window=@Window(start=-200, stop=200))
public class GenotypeAndValidate
extends RodWalker<CountedData, CountedData>
implements TreeReducible<CountedData> {
    @Output(doc="Generate a VCF file with the variants considered by the walker, with a new annotation \"callStatus\" which will carry the value called in the validation VCF or BAM file", required=false)
    protected VariantContextWriter vcfWriter = null;
    @Input(fullName="alleles", shortName="alleles", doc="The set of alleles at which to genotype", required=true)
    public RodBinding<VariantContext> alleles;
    @Argument(fullName="set_bam_truth", shortName="bt", doc="Use the calls on the reads (bam file) as the truth dataset and validate the calls on the VCF", required=false)
    private boolean bamIsTruth = false;
    @Argument(fullName="minimum_base_quality_score", shortName="mbq", doc="Minimum base quality score for calling a genotype", required=false)
    private int mbq = -1;
    @Argument(fullName="maximum_deletion_fraction", shortName="deletions", doc="Maximum deletion fraction for calling a genotype", required=false)
    private double deletions = -1.0;
    @Argument(fullName="standard_min_confidence_threshold_for_calling", shortName="stand_call_conf", doc="the minimum phred-scaled Qscore threshold to separate high confidence from low confidence calls", required=false)
    private double callConf = -1.0;
    @Argument(fullName="standard_min_confidence_threshold_for_emitting", shortName="stand_emit_conf", doc="the minimum phred-scaled Qscore threshold to emit low confidence calls", required=false)
    private double emitConf = -1.0;
    @Argument(fullName="condition_on_depth", shortName="depth", doc="Condition validation on a minimum depth of coverage by the reads", required=false)
    private int minDepth = -1;
    @Hidden
    @Argument(fullName="sample", shortName="sn", doc="Name of the sample to validate (in case your VCF/BAM has more than one sample)", required=false)
    private String sample = "";
    @Hidden
    @Argument(fullName="print_interesting_sites", shortName="print_interesting", doc="Print out interesting sites to standard out", required=false)
    private boolean printInterestingSites;
    private UnifiedGenotyperEngine snpEngine;
    private UnifiedGenotyperEngine indelEngine;
    private Set<String> samples;

    @Override
    public void initialize() {
        if (this.vcfWriter != null) {
            Map<String, VCFHeader> header = VCFUtils.getVCFHeadersFromRodPrefix(this.getToolkit(), this.alleles.getName());
            this.samples = SampleUtils.getSampleList(header, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
            Set<VCFHeaderLine> headerLines = VCFUtils.smartMergeHeaders(header.values(), logger);
            headerLines.add(new VCFHeaderLine("source", "GenotypeAndValidate"));
            this.vcfWriter.writeHeader(new VCFHeader(headerLines, this.samples));
        }
        UnifiedArgumentCollection uac = new UnifiedArgumentCollection();
        uac.OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_ALL_SITES;
        uac.alleles = this.alleles;
        uac.GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        if (this.mbq >= 0) {
            uac.MIN_BASE_QUALTY_SCORE = this.mbq;
        }
        uac.MAX_DELETION_FRACTION = this.deletions >= 0.0 ? Double.valueOf(this.deletions) : Double.valueOf(1.0);
        if (this.emitConf >= 0.0) {
            uac.STANDARD_CONFIDENCE_FOR_EMITTING = this.emitConf;
        }
        if (this.callConf >= 0.0) {
            uac.STANDARD_CONFIDENCE_FOR_CALLING = this.callConf;
        }
        uac.GLmodel = GenotypeLikelihoodsCalculationModel.Model.SNP;
        this.snpEngine = new UnifiedGenotyperEngine(this.getToolkit(), uac);
        uac.GLmodel = GenotypeLikelihoodsCalculationModel.Model.INDEL;
        this.indelEngine = new UnifiedGenotyperEngine(this.getToolkit(), uac);
        this.callConf = uac.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    @Override
    public CountedData map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        VariantCallContext call;
        CountedData counter = new CountedData();
        if (tracker == null) {
            return counter;
        }
        VariantContext vcComp = tracker.getFirstValue(this.alleles);
        if (vcComp == null) {
            return counter;
        }
        if (IndelUtils.isInsideExtendedIndel(vcComp, ref)) {
            return counter;
        }
        if (!context.hasReads() || this.minDepth > 0 && context.getBasePileup().getBases().length < this.minDepth) {
            counter.nUncovered = 1L;
            if (vcComp.getAttribute("GV").equals("T")) {
                counter.nAltNotCalled = 1L;
            } else if (vcComp.getAttribute("GV").equals("F")) {
                counter.nRefNotCalled = 1L;
            } else {
                counter.nNoStatusNotCalled = 1L;
            }
            return counter;
        }
        if (vcComp.isSNP()) {
            call = this.snpEngine.calculateLikelihoodsAndGenotypes(tracker, ref, context).get(0);
        } else if (vcComp.isIndel()) {
            call = this.indelEngine.calculateLikelihoodsAndGenotypes(tracker, ref, context).get(0);
        } else if (this.bamIsTruth) {
            call = this.snpEngine.calculateLikelihoodsAndGenotypes(tracker, ref, context).get(0);
        } else {
            logger.info("Not SNP or INDEL " + vcComp.getChr() + ":" + vcComp.getStart() + " " + vcComp.getAlleles());
            return counter;
        }
        boolean writeVariant = true;
        if (this.bamIsTruth) {
            if (call.confidentlyCalled) {
                if (call.isVariant()) {
                    if (vcComp.isVariant()) {
                        counter.nAltCalledAlt = 1L;
                    } else {
                        counter.nAltCalledRef = 1L;
                        if (this.printInterestingSites) {
                            System.out.println("Truth=ALT Call=REF at " + call.getChr() + ":" + call.getStart());
                        }
                    }
                } else if (vcComp.isVariant()) {
                    counter.nRefCalledAlt = 1L;
                    if (this.printInterestingSites) {
                        System.out.println("Truth=REF Call=ALT at " + call.getChr() + ":" + call.getStart());
                    }
                } else {
                    counter.nRefCalledRef = 1L;
                }
            } else {
                counter.nNotConfidentCalls = 1L;
                if (this.printInterestingSites) {
                    System.out.println("Truth is not confident at " + call.getChr() + ":" + call.getStart());
                }
                writeVariant = false;
            }
        } else if (call.isCalledAlt(this.callConf)) {
            if (vcComp.getAttribute("GV").equals("T")) {
                counter.nAltCalledAlt = 1L;
            } else if (vcComp.getAttribute("GV").equals("F")) {
                counter.nRefCalledAlt = 1L;
                if (this.printInterestingSites) {
                    System.out.println("Truth=REF Call=ALT at " + call.getChr() + ":" + call.getStart());
                }
            } else {
                counter.nNoStatusCalledAlt = 1L;
            }
        } else if (call.isCalledRef(this.callConf)) {
            if (vcComp.getAttribute("GV").equals("T")) {
                counter.nAltCalledRef = 1L;
                if (this.printInterestingSites) {
                    System.out.println("Truth=ALT Call=REF at " + call.getChr() + ":" + call.getStart());
                }
            } else if (vcComp.getAttribute("GV").equals("F")) {
                counter.nRefCalledRef = 1L;
            } else {
                counter.nNoStatusCalledRef = 1L;
            }
        } else {
            counter.nNotConfidentCalls = 1L;
            if (vcComp.getAttribute("GV").equals("T")) {
                counter.nAltNotCalled = 1L;
            } else if (vcComp.getAttribute("GV").equals("F")) {
                counter.nRefNotCalled = 1L;
            } else {
                counter.nNoStatusNotCalled = 1L;
            }
            if (this.printInterestingSites) {
                System.out.println("Truth is not confident at " + call.getChr() + ":" + call.getStart());
            }
            writeVariant = false;
        }
        if (this.vcfWriter != null && writeVariant) {
            if (!vcComp.hasAttribute("callStatus")) {
                this.vcfWriter.add(new VariantContextBuilder(vcComp).attribute("callStatus", call.isCalledAlt(this.callConf) ? "ALT" : "REF").make());
            } else {
                this.vcfWriter.add(vcComp);
            }
        }
        return counter;
    }

    @Override
    public CountedData reduceInit() {
        return new CountedData();
    }

    @Override
    public CountedData treeReduce(CountedData sum1, CountedData sum2) {
        sum2.add(sum1);
        return sum2;
    }

    @Override
    public CountedData reduce(CountedData mapValue, CountedData reduceSum) {
        reduceSum.add(mapValue);
        return reduceSum;
    }

    @Override
    public void onTraversalDone(CountedData reduceSum) {
        double ppv = 100.0 * ((double)reduceSum.nAltCalledAlt / (double)(reduceSum.nAltCalledAlt + reduceSum.nRefCalledAlt));
        double npv = 100.0 * ((double)reduceSum.nRefCalledRef / (double)(reduceSum.nRefCalledRef + reduceSum.nAltCalledRef));
        double sensitivity = 100.0 * ((double)reduceSum.nAltCalledAlt / (double)(reduceSum.nAltCalledAlt + reduceSum.nAltCalledRef));
        double specificity = reduceSum.nRefCalledRef + reduceSum.nRefCalledAlt > 0L ? 100.0 * ((double)reduceSum.nRefCalledRef / (double)(reduceSum.nRefCalledRef + reduceSum.nRefCalledAlt)) : 100.0;
        logger.info(String.format("Resulting Truth Table Output\n\n------------------------------------------------------------------\n\t\t|\tALT\t|\tREF\t|\tNo Status\n------------------------------------------------------------------\ncalled alt\t|\t%d\t|\t%d\t|\t%d\ncalled ref\t|\t%d\t|\t%d\t|\t%d\nnot called\t|\t%d\t|\t%d\t|\t%d\n------------------------------------------------------------------\npositive predictive value: %f%%\nnegative predictive value: %f%%\n------------------------------------------------------------------\nsensitivity: %f%%\nspecificity: %f%%\n------------------------------------------------------------------\nnot confident: %d\nnot covered: %d\n------------------------------------------------------------------\n", reduceSum.nAltCalledAlt, reduceSum.nRefCalledAlt, reduceSum.nNoStatusCalledAlt, reduceSum.nAltCalledRef, reduceSum.nRefCalledRef, reduceSum.nNoStatusCalledRef, reduceSum.nAltNotCalled, reduceSum.nRefNotCalled, reduceSum.nNoStatusNotCalled, ppv, npv, sensitivity, specificity, reduceSum.nNotConfidentCalls, reduceSum.nUncovered));
    }

    public static class CountedData {
        private long nAltCalledAlt = 0L;
        private long nAltCalledRef = 0L;
        private long nAltNotCalled = 0L;
        private long nRefCalledAlt = 0L;
        private long nRefCalledRef = 0L;
        private long nRefNotCalled = 0L;
        private long nNoStatusCalledAlt = 0L;
        private long nNoStatusCalledRef = 0L;
        private long nNoStatusNotCalled = 0L;
        private long nNotConfidentCalls = 0L;
        private long nUncovered = 0L;

        public void add(CountedData other) {
            this.nAltCalledAlt += other.nAltCalledAlt;
            this.nAltCalledRef += other.nAltCalledRef;
            this.nAltNotCalled += other.nAltNotCalled;
            this.nRefCalledAlt += other.nRefCalledAlt;
            this.nRefCalledRef += other.nRefCalledRef;
            this.nRefNotCalled += other.nRefNotCalled;
            this.nNoStatusCalledAlt += other.nNoStatusCalledAlt;
            this.nNoStatusCalledRef += other.nNoStatusCalledRef;
            this.nNoStatusNotCalled += other.nNoStatusNotCalled;
            this.nUncovered += other.nUncovered;
            this.nNotConfidentCalls += other.nNotConfidentCalls;
        }
    }
}

