/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.arguments.StandardCallerArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class UnifiedArgumentCollection
extends StandardCallerArgumentCollection {
    @Argument(fullName="genotype_likelihoods_model", shortName="glm", doc="Genotype likelihoods calculation model to employ -- SNP is the default option, while INDEL is also available for calling indels and BOTH is available for calling both together", required=false)
    public GenotypeLikelihoodsCalculationModel.Model GLmodel = GenotypeLikelihoodsCalculationModel.Model.SNP;
    @Advanced
    @Argument(fullName="p_nonref_model", shortName="pnrm", doc="Non-reference probability calculation model to employ", required=false)
    protected AlleleFrequencyCalculationModel.Model AFmodel = AlleleFrequencyCalculationModel.Model.EXACT;
    @Argument(fullName="pcr_error_rate", shortName="pcr_error", doc="The PCR error rate to be used for computing fragment-based likelihoods", required=false)
    public Double PCR_error = 1.0E-4;
    @Argument(fullName="noSLOD", shortName="nosl", doc="If provided, we will not calculate the SLOD", required=false)
    public boolean NO_SLOD = false;
    @Argument(fullName="annotateNDA", shortName="nda", doc="If provided, we will annotate records with the number of alternate alleles that were discovered (but not necessarily genotyped) at a given site", required=false)
    public boolean ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED = false;
    @Argument(fullName="min_base_quality_score", shortName="mbq", doc="Minimum base quality required to consider a base for calling", required=false)
    public int MIN_BASE_QUALTY_SCORE = 17;
    @Argument(fullName="max_deletion_fraction", shortName="deletions", doc="Maximum fraction of reads with deletions spanning this locus for it to be callable [to disable, set to < 0 or > 1; default:0.05]", required=false)
    public Double MAX_DELETION_FRACTION = 0.05;
    @Hidden
    @Argument(fullName="cap_max_alternate_alleles_for_indels", shortName="capMaxAltAllelesForIndels", doc="Cap the maximum number of alternate alleles to genotype for indel calls at 2; overrides the --max_alternate_alleles argument; GSA production use only", required=false)
    public boolean CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS = false;
    @Argument(fullName="min_indel_count_for_genotyping", shortName="minIndelCnt", doc="Minimum number of consensus indels required to trigger genotyping run", required=false)
    public int MIN_INDEL_COUNT_FOR_GENOTYPING = 5;
    @Argument(fullName="min_indel_fraction_per_sample", shortName="minIndelFrac", doc="Minimum fraction of all reads at a locus that must contain an indel (of any allele) for that sample to contribute to the indel count for alleles", required=false)
    public double MIN_INDEL_FRACTION_PER_SAMPLE = 0.25;
    @Argument(fullName="indel_heterozygosity", shortName="indelHeterozygosity", doc="Heterozygosity for indel calling", required=false)
    public double INDEL_HETEROZYGOSITY = 1.25E-4;
    @Advanced
    @Argument(fullName="indelGapContinuationPenalty", shortName="indelGCP", doc="Indel gap continuation penalty, as Phred-scaled probability.  I.e., 30 => 10^-30/10", required=false)
    public byte INDEL_GAP_CONTINUATION_PENALTY = (byte)10;
    @Advanced
    @Argument(fullName="indelGapOpenPenalty", shortName="indelGOP", doc="Indel gap open penalty, as Phred-scaled probability.  I.e., 30 => 10^-30/10", required=false)
    public byte INDEL_GAP_OPEN_PENALTY = (byte)45;
    @Hidden
    @Argument(fullName="indelHaplotypeSize", shortName="indelHSize", doc="Indel haplotype size", required=false)
    public int INDEL_HAPLOTYPE_SIZE = 80;
    @Hidden
    @Argument(fullName="noBandedIndel", shortName="noBandedIndel", doc="Don't do Banded Indel likelihood computation", required=false)
    public boolean DONT_DO_BANDED_INDEL_COMPUTATION = false;
    @Hidden
    @Argument(fullName="indelDebug", shortName="indelDebug", doc="Output indel debug info", required=false)
    public boolean OUTPUT_DEBUG_INDEL_INFO = false;
    @Hidden
    @Argument(fullName="ignoreSNPAlleles", shortName="ignoreSNPAlleles", doc="expt", required=false)
    public boolean IGNORE_SNP_ALLELES = false;
    @Hidden
    @Argument(fullName="allReadsSP", shortName="dl", doc="expt", required=false)
    public boolean TREAT_ALL_READS_AS_SINGLE_POOL = false;
    @Argument(fullName="ignoreLaneInfo", shortName="ignoreLane", doc="Ignore lane when building error model, error model is then per-site", required=false)
    public boolean IGNORE_LANE_INFO = false;
    @Input(fullName="reference_sample_calls", shortName="referenceCalls", doc="VCF file with the truth callset for the reference sample", required=false)
    RodBinding<VariantContext> referenceSampleRod;
    @Argument(shortName="refsample", fullName="reference_sample_name", doc="Reference sample name.", required=false)
    String referenceSampleName;
    @Argument(shortName="ploidy", fullName="sample_ploidy", doc="Plody (number of chromosomes) per sample. For pooled data, set to (Number of samples in each pool * Sample Ploidy).", required=false)
    int samplePloidy = 2;
    @Hidden
    @Argument(shortName="minqs", fullName="min_quality_score", doc="Min quality score to consider. Smaller numbers process faster. Default: Q1.", required=false)
    byte minQualityScore = 1;
    @Hidden
    @Argument(shortName="maxqs", fullName="max_quality_score", doc="Max quality score to consider. Smaller numbers process faster. Default: Q40.", required=false)
    byte maxQualityScore = (byte)40;
    @Hidden
    @Argument(shortName="site_prior", fullName="site_quality_prior", doc="Phred-Scaled prior quality of the site. Default: Q20.", required=false)
    byte phredScaledPrior = (byte)20;
    @Hidden
    @Argument(shortName="min_call_power", fullName="min_power_threshold_for_calling", doc="The minimum confidence in the error model to make a call. Number should be between 0 (no power requirement) and 1 (maximum power required).", required=false)
    double minPower = 0.95;
    @Hidden
    @Argument(shortName="min_depth", fullName="min_reference_depth", doc="The minimum depth required in the reference sample in order to make a call.", required=false)
    int minReferenceDepth = 100;
    @Hidden
    @Argument(shortName="ef", fullName="exclude_filtered_reference_sites", doc="Don't include in the analysis sites where the reference sample VCF is filtered. Default: false.", required=false)
    boolean EXCLUDE_FILTERED_REFERENCE_SITES = false;

    public UnifiedArgumentCollection clone() {
        UnifiedArgumentCollection uac = new UnifiedArgumentCollection();
        uac.GLmodel = this.GLmodel;
        uac.AFmodel = this.AFmodel;
        uac.heterozygosity = this.heterozygosity;
        uac.PCR_error = this.PCR_error;
        uac.GenotypingMode = this.GenotypingMode;
        uac.OutputMode = this.OutputMode;
        uac.NO_SLOD = this.NO_SLOD;
        uac.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED = this.ANNOTATE_NUMBER_OF_ALLELES_DISCOVERED;
        uac.STANDARD_CONFIDENCE_FOR_CALLING = this.STANDARD_CONFIDENCE_FOR_CALLING;
        uac.STANDARD_CONFIDENCE_FOR_EMITTING = this.STANDARD_CONFIDENCE_FOR_EMITTING;
        uac.MIN_BASE_QUALTY_SCORE = this.MIN_BASE_QUALTY_SCORE;
        uac.MAX_DELETION_FRACTION = this.MAX_DELETION_FRACTION;
        uac.MIN_INDEL_COUNT_FOR_GENOTYPING = this.MIN_INDEL_COUNT_FOR_GENOTYPING;
        uac.MIN_INDEL_FRACTION_PER_SAMPLE = this.MIN_INDEL_FRACTION_PER_SAMPLE;
        uac.INDEL_HETEROZYGOSITY = this.INDEL_HETEROZYGOSITY;
        uac.INDEL_GAP_OPEN_PENALTY = this.INDEL_GAP_OPEN_PENALTY;
        uac.INDEL_GAP_CONTINUATION_PENALTY = this.INDEL_GAP_CONTINUATION_PENALTY;
        uac.OUTPUT_DEBUG_INDEL_INFO = this.OUTPUT_DEBUG_INDEL_INFO;
        uac.INDEL_HAPLOTYPE_SIZE = this.INDEL_HAPLOTYPE_SIZE;
        uac.alleles = this.alleles;
        uac.MAX_ALTERNATE_ALLELES = this.MAX_ALTERNATE_ALLELES;
        uac.CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS = this.CAP_MAX_ALTERNATE_ALLELES_FOR_INDELS;
        uac.GLmodel = this.GLmodel;
        uac.TREAT_ALL_READS_AS_SINGLE_POOL = this.TREAT_ALL_READS_AS_SINGLE_POOL;
        uac.referenceSampleRod = this.referenceSampleRod;
        uac.referenceSampleName = this.referenceSampleName;
        uac.samplePloidy = this.samplePloidy;
        uac.maxQualityScore = this.minQualityScore;
        uac.phredScaledPrior = this.phredScaledPrior;
        uac.minPower = this.minPower;
        uac.minReferenceDepth = this.minReferenceDepth;
        uac.EXCLUDE_FILTERED_REFERENCE_SITES = this.EXCLUDE_FILTERED_REFERENCE_SITES;
        uac.IGNORE_LANE_INFO = this.IGNORE_LANE_INFO;
        uac.IGNORE_SNP_ALLELES = this.IGNORE_SNP_ALLELES;
        uac.DONT_DO_BANDED_INDEL_COMPUTATION = this.DONT_DO_BANDED_INDEL_COMPUTATION;
        return uac;
    }

    public UnifiedArgumentCollection() {
    }

    public UnifiedArgumentCollection(StandardCallerArgumentCollection SCAC) {
        this.alleles = SCAC.alleles;
        this.GenotypingMode = SCAC.GenotypingMode;
        this.heterozygosity = SCAC.heterozygosity;
        this.MAX_ALTERNATE_ALLELES = SCAC.MAX_ALTERNATE_ALLELES;
        this.OutputMode = SCAC.OutputMode;
        this.STANDARD_CONFIDENCE_FOR_CALLING = SCAC.STANDARD_CONFIDENCE_FOR_CALLING;
        this.STANDARD_CONFIDENCE_FOR_EMITTING = SCAC.STANDARD_CONFIDENCE_FOR_EMITTING;
    }
}

