/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class GenotypeLikelihoodsCalculationModel
implements Cloneable {
    public static final String DUMMY_LANE = "Lane1";
    public static final String DUMMY_SAMPLE_NAME = "DummySample1";
    protected final UnifiedArgumentCollection UAC;
    protected Logger logger;

    protected GenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        if (logger == null || UAC == null) {
            throw new ReviewedStingException("Bad arguments");
        }
        this.UAC = UAC;
        this.logger = logger;
    }

    public abstract VariantContext getLikelihoods(RefMetaDataTracker var1, ReferenceContext var2, Map<String, AlignmentContext> var3, AlignmentContextUtils.ReadOrientation var4, List<Allele> var5, boolean var6, GenomeLocParser var7);

    protected int getFilteredDepth(ReadBackedPileup pileup) {
        int count = 0;
        for (PileupElement p : pileup) {
            if (!BaseUtils.isRegularBase(p.getBase())) continue;
            count += p.getRepresentativeCount();
        }
        return count;
    }

    public static enum GENOTYPING_MODE {
        DISCOVERY,
        GENOTYPE_GIVEN_ALLELES;

    }

    public static enum Model {
        SNP,
        INDEL,
        GeneralPloidySNP,
        GeneralPloidyINDEL,
        BOTH;

    }
}

