/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.SampleStatistics;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.ThresHolder;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

class IntervalStatistics {
    private final Map<String, SampleStatistics> samples;
    private final GenomeLoc interval;
    private boolean hasNref = false;
    private int preComputedTotalCoverage = -1;

    public IntervalStatistics(Set<String> samples, GenomeLoc interval) {
        this.interval = interval;
        this.samples = new HashMap<String, SampleStatistics>(samples.size());
        for (String sample : samples) {
            this.samples.put(sample, new SampleStatistics(interval));
        }
    }

    public SampleStatistics getSample(String sample) {
        return this.samples.get(sample);
    }

    public GenomeLoc getInterval() {
        return this.interval;
    }

    public void addLocus(AlignmentContext context, ReferenceContext ref, ThresHolder thresholds) {
        ReadBackedPileup pileup = context.getBasePileup();
        Map<String, ReadBackedPileup> samplePileups = pileup.getPileupsForSamples(this.samples.keySet());
        for (Map.Entry<String, ReadBackedPileup> entry : samplePileups.entrySet()) {
            String sample = entry.getKey();
            ReadBackedPileup samplePileup = entry.getValue();
            SampleStatistics sampleStatistics = this.samples.get(sample);
            if (sampleStatistics == null) {
                throw new ReviewedStingException(String.format("Trying to add locus statistics to a sample (%s) that doesn't exist in the Interval.", sample));
            }
            sampleStatistics.addLocus(context.getLocation(), samplePileup, thresholds);
        }
        if (!this.hasNref && ref.getBase() == 78) {
            this.hasNref = true;
        }
    }

    public double averageCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return (double)this.preComputedTotalCoverage / (double)this.interval.size();
    }

    private void calculateTotalCoverage() {
        this.preComputedTotalCoverage = 0;
        for (SampleStatistics sample : this.samples.values()) {
            this.preComputedTotalCoverage = (int)((long)this.preComputedTotalCoverage + sample.totalCoverage());
        }
    }

    public Set<CallableStatus> callableStatuses(ThresHolder thresholds) {
        HashSet<CallableStatus> output = new HashSet<CallableStatus>();
        HashMap<CallableStatus, Integer> votes = new HashMap<CallableStatus, Integer>();
        for (CallableStatus status : CallableStatus.values()) {
            votes.put(status, 0);
        }
        for (SampleStatistics sample : this.samples.values()) {
            for (CallableStatus status : sample.getCallableStatuses(thresholds)) {
                votes.put(status, (Integer)votes.get((Object)status) + 1);
            }
        }
        for (CallableStatus status : votes.keySet()) {
            if (!((double)((Integer)votes.get((Object)status)).intValue() > (double)this.samples.size() * thresholds.getVotePercentageThreshold()) || status.equals((Object)CallableStatus.PASS)) continue;
            output.add(status);
        }
        if (this.hasNref) {
            output.add(CallableStatus.REF_N);
        }
        int nLowMedianDepth = 0;
        for (SampleStatistics sample : this.samples.values()) {
            if (!(sample.getQuantileDepth(0.5) < (double)thresholds.getMinimumMedianDepth())) continue;
            ++nLowMedianDepth;
        }
        if ((double)nLowMedianDepth > (double)this.samples.size() * thresholds.getLowMedianDepthThreshold()) {
            output.add(CallableStatus.LOW_MEDIAN_DEPTH);
        }
        return output;
    }
}

