/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.walkers.coverage.DoCOutputType;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.pileup.PileupElement;

public class CoverageUtils {
    public static int[] getBaseCounts(AlignmentContext context, int minMapQ, int minBaseQ) {
        int[] counts = new int[6];
        for (PileupElement e : context.getBasePileup()) {
            if (e.getMappingQual() < minMapQ || e.getQual() < minBaseQ && !e.isDeletion()) continue;
            CoverageUtils.updateCounts(counts, e);
        }
        return counts;
    }

    public static String getTypeID(SAMReadGroupRecord r, DoCOutputType.Partition type) {
        if (type == DoCOutputType.Partition.sample) {
            return r.getSample();
        }
        if (type == DoCOutputType.Partition.readgroup) {
            return String.format("%s_rg_%s", r.getSample(), r.getReadGroupId());
        }
        if (type == DoCOutputType.Partition.library) {
            return r.getLibrary();
        }
        if (type == DoCOutputType.Partition.center) {
            return r.getSequencingCenter();
        }
        if (type == DoCOutputType.Partition.platform) {
            return r.getPlatform();
        }
        if (type == DoCOutputType.Partition.sample_by_center) {
            return String.format("%s_cn_%s", r.getSample(), r.getSequencingCenter());
        }
        if (type == DoCOutputType.Partition.sample_by_platform) {
            return String.format("%s_pl_%s", r.getSample(), r.getPlatform());
        }
        if (type == DoCOutputType.Partition.sample_by_platform_by_center) {
            return String.format("%s_pl_%s_cn_%s", r.getSample(), r.getPlatform(), r.getSequencingCenter());
        }
        throw new ReviewedStingException("Invalid type ID sent to getTypeID. This is a BUG!");
    }

    public static Map<DoCOutputType.Partition, Map<String, int[]>> getBaseCountsByPartition(AlignmentContext context, int minMapQ, int maxMapQ, byte minBaseQ, byte maxBaseQ, Collection<DoCOutputType.Partition> types) {
        HashMap<DoCOutputType.Partition, Map<String, int[]>> countsByIDByType = new HashMap<DoCOutputType.Partition, Map<String, int[]>>();
        Map<SAMReadGroupRecord, int[]> countsByRG = CoverageUtils.getBaseCountsByReadGroup(context, minMapQ, maxMapQ, minBaseQ, maxBaseQ);
        for (DoCOutputType.Partition t : types) {
            for (Map.Entry<SAMReadGroupRecord, int[]> readGroupCountEntry : countsByRG.entrySet()) {
                String typeID = CoverageUtils.getTypeID(readGroupCountEntry.getKey(), t);
                if (!countsByIDByType.keySet().contains((Object)t)) {
                    countsByIDByType.put(t, new HashMap());
                }
                if (!((Map)countsByIDByType.get((Object)t)).keySet().contains(typeID)) {
                    ((Map)countsByIDByType.get((Object)t)).put(typeID, readGroupCountEntry.getValue().clone());
                    continue;
                }
                CoverageUtils.addCounts((int[])((Map)countsByIDByType.get((Object)t)).get(typeID), readGroupCountEntry.getValue());
            }
        }
        return countsByIDByType;
    }

    public static void addCounts(int[] updateMe, int[] leaveMeAlone) {
        for (int index = 0; index < leaveMeAlone.length; ++index) {
            int n = index;
            updateMe[n] = updateMe[n] + leaveMeAlone[index];
        }
    }

    public static Map<SAMReadGroupRecord, int[]> getBaseCountsByReadGroup(AlignmentContext context, int minMapQ, int maxMapQ, byte minBaseQ, byte maxBaseQ) {
        HashMap<SAMReadGroupRecord, int[]> countsByRG = new HashMap<SAMReadGroupRecord, int[]>();
        for (PileupElement e : context.getBasePileup()) {
            if (e.getMappingQual() < minMapQ || e.getMappingQual() > maxMapQ || (e.getQual() < minBaseQ || e.getQual() > maxBaseQ) && !e.isDeletion()) continue;
            SAMReadGroupRecord readGroup = CoverageUtils.getReadGroup(e.getRead());
            if (!countsByRG.keySet().contains(readGroup)) {
                countsByRG.put(readGroup, new int[6]);
                CoverageUtils.updateCounts((int[])countsByRG.get(readGroup), e);
                continue;
            }
            CoverageUtils.updateCounts((int[])countsByRG.get(readGroup), e);
        }
        return countsByRG;
    }

    private static void updateCounts(int[] counts, PileupElement e) {
        if (e.isDeletion()) {
            counts[4] = counts[4] + 1;
        } else if (BaseUtils.basesAreEqual((byte)78, e.getBase())) {
            counts[5] = counts[5] + 1;
        } else {
            try {
                int n = BaseUtils.simpleBaseToBaseIndex(e.getBase());
                counts[n] = counts[n] + 1;
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                throw new ReviewedStingException("Expected a simple base, but actually received" + (char)e.getBase());
            }
        }
    }

    private static SAMReadGroupRecord getReadGroup(SAMRecord r) {
        SAMReadGroupRecord rg = r.getReadGroup();
        if (rg == null) {
            String msg = "Read " + r.getReadName() + " lacks read group information; Please associate all reads with read groups";
            throw new UserException.MalformedBAM(r, msg);
        }
        return rg;
    }
}

