/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Gatherer;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationReport;

public class BQSRGatherer
extends Gatherer {
    private static final String EMPTY_INPUT_LIST = "list of inputs files is empty";
    private static final String MISSING_OUTPUT_FILE = "missing output file name";

    @Override
    public void gather(List<File> inputs, File output) {
        File recal_out;
        PrintStream outputFile;
        RecalibrationReport generalReport = null;
        try {
            outputFile = new PrintStream(output);
        }
        catch (FileNotFoundException e) {
            throw new UserException.MissingArgument("output", MISSING_OUTPUT_FILE);
        }
        for (File input : inputs) {
            RecalibrationReport inputReport = new RecalibrationReport(input);
            if (generalReport == null) {
                generalReport = inputReport;
                continue;
            }
            generalReport.combine(inputReport);
        }
        if (generalReport == null) {
            throw new ReviewedStingException(EMPTY_INPUT_LIST);
        }
        generalReport.calculateQuantizedQualities();
        RecalibrationArgumentCollection RAC = generalReport.getRAC();
        if (RAC.recalibrationReport != null && !RAC.NO_PLOTS) {
            recal_out = new File(output.getName() + ".original");
            RecalibrationReport originalReport = new RecalibrationReport(RAC.recalibrationReport);
            RecalUtils.generateRecalibrationPlot(recal_out, originalReport.getRecalibrationTables(), generalReport.getRecalibrationTables(), generalReport.getCovariates(), RAC.KEEP_INTERMEDIATE_FILES);
        } else if (!RAC.NO_PLOTS) {
            recal_out = new File(output.getName() + ".recal");
            RecalUtils.generateRecalibrationPlot(recal_out, generalReport.getRecalibrationTables(), generalReport.getCovariates(), RAC.KEEP_INTERMEDIATE_FILES);
        }
        generalReport.output(outputFile);
    }
}

