/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.refdata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.datasources.providers.RODMetaDataContainer;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class ReadMetaDataTracker {
    private final GenomeLocParser genomeLocParser;
    private final SAMRecord record;
    private final TreeMap<Integer, RODMetaDataContainer> mapping;

    public ReadMetaDataTracker(GenomeLocParser genomeLocParser, SAMRecord record, TreeMap<Integer, RODMetaDataContainer> mapping) {
        this.genomeLocParser = genomeLocParser;
        this.record = record;
        this.mapping = mapping;
    }

    private Map<Integer, Collection<GATKFeature>> createReadAlignment(SAMRecord record, TreeMap<Integer, RODMetaDataContainer> queue, Class cl, String name) {
        if (name != null && cl != null) {
            throw new IllegalStateException("Both a class and name cannot be specified");
        }
        LinkedHashMap<Integer, Collection<GATKFeature>> ret = new LinkedHashMap<Integer, Collection<GATKFeature>>();
        GenomeLoc location = this.genomeLocParser.createGenomeLoc(record);
        int length = record.getReadLength();
        for (Integer loc : queue.keySet()) {
            Collection<GATKFeature> set;
            Integer position = loc - location.getStart();
            if (position < 0 || position >= length || (set = cl != null ? queue.get(loc).getSet(cl) : queue.get(loc).getSet(name)) == null || set.size() <= 0) continue;
            ret.put(position, set);
        }
        return ret;
    }

    private Map<Integer, Collection<GATKFeature>> createGenomeLocAlignment(SAMRecord record, TreeMap<Integer, RODMetaDataContainer> mapping, Class cl, String name) {
        LinkedHashMap<Integer, Collection<GATKFeature>> ret = new LinkedHashMap<Integer, Collection<GATKFeature>>();
        int start = record.getAlignmentStart();
        int stop = record.getAlignmentEnd();
        for (Integer location : mapping.keySet()) {
            if (location < start || location > stop) continue;
            if (cl != null) {
                ret.put(location, mapping.get(location).getSet(cl));
                continue;
            }
            ret.put(location, mapping.get(location).getSet(name));
        }
        return ret;
    }

    public Map<Integer, Collection<GATKFeature>> getReadOffsetMapping() {
        return this.createReadAlignment(this.record, this.mapping, null, null);
    }

    public Map<Integer, Collection<GATKFeature>> getContigOffsetMapping() {
        return this.createGenomeLocAlignment(this.record, this.mapping, null, null);
    }

    public Map<Integer, Collection<GATKFeature>> getReadOffsetMapping(String name) {
        return this.createReadAlignment(this.record, this.mapping, null, name);
    }

    public Map<Integer, Collection<GATKFeature>> getContigOffsetMapping(String name) {
        return this.createGenomeLocAlignment(this.record, this.mapping, null, name);
    }

    public Map<Integer, Collection<GATKFeature>> getReadOffsetMapping(Class cl) {
        return this.createReadAlignment(this.record, this.mapping, cl, null);
    }

    public Map<Integer, Collection<GATKFeature>> getContigOffsetMapping(Class cl) {
        return this.createGenomeLocAlignment(this.record, this.mapping, cl, null);
    }

    public List<GATKFeature> getAllCoveringRods() {
        ArrayList<GATKFeature> ret = new ArrayList<GATKFeature>();
        for (Map.Entry<Integer, RODMetaDataContainer> entry : this.mapping.entrySet()) {
            ret.addAll(entry.getValue().getSet());
        }
        return ret;
    }
}

