/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReferenceView
implements View {
    protected final GenomeLocParser genomeLocParser;
    protected IndexedFastaSequenceFile reference = null;
    static final int BUFFER = 10000;
    static final byte[] Xs = new byte[10000];

    public ReferenceView(ShardDataProvider provider) {
        this.genomeLocParser = provider.getGenomeLocParser();
        this.reference = provider.getReference();
    }

    @Override
    public Collection<Class<? extends View>> getConflictingViews() {
        return Collections.emptyList();
    }

    @Override
    public void close() {
        this.reference = null;
    }

    protected byte[] getReferenceBases(SAMRecord read) {
        return this.getReferenceBases(this.genomeLocParser.createGenomeLoc(read));
    }

    protected byte[] getReferenceBases(GenomeLoc genomeLoc) {
        SAMSequenceRecord sequenceInfo = this.reference.getSequenceDictionary().getSequence(genomeLoc.getContig());
        long start = genomeLoc.getStart();
        long stop = Math.min(genomeLoc.getStop(), sequenceInfo.getSequenceLength());
        if (stop - start + 1L == 0L) {
            return new byte[0];
        }
        ReferenceSequence subsequence = this.reference.getSubsequenceAt(genomeLoc.getContig(), start, stop);
        int overhang = (int)((long)genomeLoc.getStop() - stop);
        if (overhang > 0) {
            if (overhang > 10000) {
                throw new ReviewedStingException("Insufficient buffer size for Xs overhanging genome -- expand BUFFER");
            }
            byte[] all = new byte[subsequence.getBases().length + overhang];
            System.arraycopy(subsequence.getBases(), 0, all, 0, subsequence.getBases().length);
            System.arraycopy(Xs, 0, all, subsequence.getBases().length, overhang);
            return all;
        }
        return subsequence.getBases();
    }

    static {
        Arrays.fill(Xs, (byte)88);
    }
}

