/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.broadinstitute.sting.alignment.Aligner;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.BWAConfiguration;
import org.broadinstitute.sting.alignment.bwa.BWTFiles;
import org.broadinstitute.sting.alignment.bwa.c.BWACAligner;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="BAM Processing and Analysis Tools", extraDocs={CommandLineGATK.class})
public class CountBestAlignments
extends ReadWalker<Integer, Integer> {
    @Argument(fullName="BWTPrefix", shortName="BWT", doc="Index files generated by bwa index -d bwtsw", required=false)
    private String prefix = null;
    @Output
    private PrintStream out = null;
    private Aligner aligner = null;
    private SortedMap<Integer, Integer> alignmentFrequencies = new TreeMap<Integer, Integer>();

    @Override
    public void initialize() {
        if (this.prefix == null) {
            this.prefix = this.getToolkit().getArguments().referenceFile.getAbsolutePath();
        }
        BWTFiles bwtFiles = new BWTFiles(this.prefix);
        BWAConfiguration configuration = new BWAConfiguration();
        this.aligner = new BWACAligner(bwtFiles, configuration);
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        Iterator<Alignment[]> alignmentIterator = this.aligner.getAllAlignments(read.getReadBases()).iterator();
        if (alignmentIterator.hasNext()) {
            int numAlignments = alignmentIterator.next().length;
            if (this.alignmentFrequencies.containsKey(numAlignments)) {
                this.alignmentFrequencies.put(numAlignments, (Integer)this.alignmentFrequencies.get(numAlignments) + 1);
            } else {
                this.alignmentFrequencies.put(numAlignments, 1);
            }
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.aligner.close();
        for (Map.Entry<Integer, Integer> alignmentFrequency : this.alignmentFrequencies.entrySet()) {
            this.out.printf("%d\t%d%n", alignmentFrequency.getKey(), alignmentFrequency.getValue());
        }
        super.onTraversalDone(result);
    }
}

