<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- 
  This file is automatically built from gomo.xsl.in at MAKE time.

  This stylesheet transforms the XML output of GOMO into HTML.
-->

  <xsl:output method="html" indent="yes" 
    doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system="http://www.w3.org/TR/html4/loose.dtd"
  />
  <xsl:strip-space elements="*"/>

  <!-- Stylesheet processing starts here -->
  <xsl:template match="/gomo">
    <html>
      <xsl:call-template name="html-head"/>
      <body>
        <form 
          enctype="application/x-www-form-urlencoded"
          method = "POST"
          target = "_new"
          action = "http://meme.nbcr.net/meme/cgi-bin/process_request.cgi"
        >
        <!-- Create the various sub-sections of the document -->
        <xsl:call-template name="top-buttons"/>
		<xsl:call-template name="gomo-version"/>
        <xsl:call-template name="reference"/>
        <xsl:call-template name="input-data"/>
        <xsl:call-template name="model"/>
        <xsl:call-template name="motifs"/>
        <xsl:call-template name="explanation"/>
      </form>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="html-head">
    <!-- This template prints the HTML head block, including the document level CSS. -->
    <head>
      <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
      <title>GOMO Results</title>
	  <style type="text/css">
        td.left {text-align: left;}
        td.right {text-align: right; padding-right: 1cm;}
		td {font-size:12px;font-family:verdana,arial,helvetica;}
		headline {font-size:14px;font-family:verdana,arial,helvetica;text-align: center; font-weight:bold}
		section {font-size:14px;font-family:verdana,arial,helvetica; font-weight:bold}
		body {background-color:FFFFFF;font-size:12px;font-family:verdana,arial,helvetica;}
      </style>
    </head>
  </xsl:template>
  
  <xsl:template name="top-buttons">
		<a name="top_buttons" />
		<table summary="buttons" align="left" cellspacing="0"><tr>
		<td bgcolor="#00FFFF"><a href="#reference"><b>Reference</b></a></td>
	  	<td bgcolor="#DDDDFF"><a href="#command"><b>Command line</b></a></td>
		<td bgcolor="#DDFFDD"><a href="#sequences"><b>Input data</b></a></td>
		<td bgcolor="#FFDDFF"><a href="#motif_association"><b>Motif - GO term association</b></a></td>
		<td bgcolor="#FFFF00"><a href="#explanation"><b>Explanation</b></a></td>
		</tr></table><br />
  </xsl:template>

  <xsl:template name="gomo-version">
    <!-- This template prints the HTML describing the version of GOMO that generated this document. -->
    <hr /><a name="version" />
    <table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#FFFFFF">
      <center>
      <headline><a href="#version_doc"><xsl:value-of select="/gomo/program-name" /> 
      	(<xsl:value-of select="/gomo/@version"/>) - Gene Ontology for Motifs</a>
      </headline>
      </center>
    </td></tr><tr><td bgcolor="#FFFFFF">
     <p>
     For further information on how to interpret these results or to get
     a copy of the MEME software please access 
     <a href="http://meme.sdsc.edu">http://meme.sdsc.edu</a>.
     </p>
    </td></tr></table><br/>
  </xsl:template>

  <xsl:template name="reference">
    <!-- This template prints the instructions for citing GOMO. -->
    <a name="reference"/>
    <table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#00FFFF">
      <section><a href="#reference_doc">REFERENCE</a></section>
    </td></tr><tr><td bgcolor="#FFFFFF">
    <p>
    If you use this program in your research, please cite:
    </p>
    <h4>
    Mikael Boden and Timothy L. Bailey,
    "Associating transcription factor binding site motifs with target
	Go terms and target genes", Nucl. Acids Res (2008).
    </h4>
    </td></tr></table><br/>
  </xsl:template>

  <xsl:template name="input-data">
    <!-- 
      This template prints the HTML describing the input sequences
      that were used to generate this document.
     -->
  	<a name="sequences"/>
  	<table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#DDFFDD">
        <section><a href="#sequences_doc">INPUT DATA</a></section>
  	</td></tr><tr><td bgcolor="#FFFFFF">
  	<xsl:for-each select="/gomo/species">
    	<xsl:variable name="speciesid" select="@id" />
    	<xsl:if test="$speciesid != 0">
	      <b>species (<xsl:value-of select="@id"/>) <xsl:value-of select="@name"/></b><br/>
  	    scored sequence file: <xsl:value-of select="input-files/scoring-file"/><br/>
    		go-term-sequence mapping: <xsl:value-of select="input-files/godb-file"/><br/>
      	<br/>
      </xsl:if>
    </xsl:for-each>
    </td></tr></table><br/>
  </xsl:template>

  <xsl:template name="model">
    <!-- This template print the HTML describing the MEME input parameters. -->
    <a name="command"/>
    <table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#DDDDFF">
      <section><a href="#command_doc">COMMAND LINE SUMMARY</a></section>
    </td></tr><tr><td bgcolor="#FFFFFF">
    <pre>
This information can also be useful in the event you wish to report a
problem with the GOMO software.

command: <xsl:value-of select="/gomo/model/command_line"/><br/>
significance threshold: <xsl:value-of select="/gomo/model/significance_threshold"/><br/>
    </pre>
    </td></tr></table><br/>
  </xsl:template>

  <xsl:template name="motifs">
  	<a name="motif_association"/>
  	<table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#FFDDFF">
  	<section><a href="#motif_doc">Motif - GO term association</a></section>
    </td></tr>
    <xsl:for-each select="/gomo/species">
    	<tr><td bgcolor="#FFDDFF">
    	<b>Species (<xsl:value-of select="@id"/>) <xsl:value-of select="@name"/></b>
    	</td></tr><tr><td bgcolor="#FFFFFF">
      <xsl:call-template name="species"/>
      </td></tr>
    </xsl:for-each>
    </table><br/>
  </xsl:template>

  <xsl:template name="species">
  	<xsl:variable name="species" select="@id" />
  	<section><a href="#motif_doc">Motifs</a>: </section>
    <xsl:for-each select="pattern">
    	<xsl:variable name="acc" select="@accession" />
      <a href="#{$species}_{$acc}"><xsl:value-of select="@accession"/></a>&#160;
    </xsl:for-each>
    <br />
    
    <xsl:for-each select="pattern">
    	<xsl:variable name="acc" select="@accession" />
    	<a name="{$species}_{$acc}" />
      <b>MOTIF <xsl:value-of select="@accession"/> <xsl:value-of select="@name"/></b><br/>
      <xsl:call-template name="pattern"/>
      <br />
    </xsl:for-each>
  </xsl:template>
  
  <xsl:template name="pattern">
	  <xsl:choose>
	  <xsl:when test="goterm">
	    <table cellspacing='2' cellpadding='2'>
	    <tr>
	    	<td>Go term</td>
	    	<td><i>E</i>-value</td>
	    	<td>q-value</td>
	    	<td>GO definition</td>
	    </tr>
	    <xsl:for-each select="goterm">
	      <xsl:call-template name="goterm"/>
	    </xsl:for-each>
	    </table>
	  </xsl:when>
	  <xsl:otherwise>
	    <i>... no significant GO-term could be associated with this motif ...</i><br/>
	  </xsl:otherwise>
		</xsl:choose>
  </xsl:template>  
    
  <xsl:template name="goterm">
  	<xsl:variable name="gotermid" select="@id" />
      <tr valign="top">
      	<td><a href="http://amigo.geneontology.org/cgi-bin/amigo//term-details.cgi?term={$gotermid}" target="go_query"><xsl:value-of select="@id"/></a></td>
      	<td align="right"><xsl:value-of select="@E-value"/></td>
      	<td align="right"><xsl:value-of select="@qvalue"/></td>
      	<td><xsl:value-of select="@description"/></td>
      </tr>
  </xsl:template>

  <xsl:template name="explanation">
    <!-- This template prints the boilerplate HTML describing the GOMO output document -->
    <a name="explanation"/>
    <table width="100%" border="0" cellspacing="1" cellpadding="4" bgcolor="#AAAAAA"><tr><td bgcolor="#FFFF00">
  	    EXPLANATION OF GOMO RESULTS
    </td></tr><tr><td bgcolor="#FFFFFF">
    <h4>The GOMO results consist of:</h4>
    <ul>
      <li><a name="version_doc"/>
        The <a href="#version"><b>version</b></a>
         of GOMO.
      </li>
      <li><a name="reference_doc"/>
        The <a href="#reference"><b>reference</b></a>
        to cite if you use GOMO in your research.
      </li>
      <li><a name="sequences_doc"/>
        The list of <a href="#sequences"><b>input data</b></a> used for the 
				the calculations.
      </li>
      <li><a name="command_doc"/>
        The <a href="#command"><b>command line summary</b></a> 
        detailing the parameters with which you ran GOMO.
      </li>
      <li><a name="motif_doc"/>
        The result of the <a href="#motif_association"><b>Motifs</b></a> used to search
        for GO terms associated with putative target genes.  
      </li>
     </ul>
     </td></tr></table><br/>
  </xsl:template>

</xsl:stylesheet>
