(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3074,         90]*)
(*NotebookOutlinePosition[      3712,        113]*)
(*  CellTagsIndexPosition[      3668,        109]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(\(ClearAll[u, x, y];\)\), "\[IndentingNewLine]", 
    \(\(u[x_, y_]\  = \ a\  + \ b\ x\  + \ c\ y;\)\), "\[IndentingNewLine]", 
    \(sol = 
      Simplify[First[
          Solve[{u[x1, y1] \[Equal] u1, u[x2, y2] \[Equal] u2, 
              u[x3, y3] \[Equal] u3}, {a, b, c}]]]\)}], "Input"],

Cell[BoxData[
    \({a \[Rule] \(u3\ x2\ y1 - u2\ x3\ y1 - u3\ x1\ y2 + u1\ x3\ y2 + u2\ x1\
\ y3 - u1\ x2\ y3\)\/\(x2\ y1 - x3\ y1 - x1\ y2 + x3\ y2 + x1\ y3 - x2\ y3\), 
      b \[Rule] \(u2\ y1 - u3\ y1 - u1\ y2 + u3\ y2 + u1\ y3 - u2\ y3\)\/\(x2\
\ y1 - x3\ y1 - x1\ y2 + x3\ y2 + x1\ y3 - x2\ y3\), 
      c \[Rule] \(u2\ x1 - u3\ x1 - u1\ x2 + u3\ x2 + u1\ x3 - u2\ \
x3\)\/\(\(-x2\)\ y1 + x3\ y1 + x1\ y2 - x3\ y2 - x1\ y3 + x2\ y3\)}\)], \
"Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a /. sol // FullSimplify\)], "Input"],

Cell[BoxData[
    \(\(u3\ x2\ y1 - u2\ x3\ y1 - u3\ x1\ y2 + u1\ x3\ y2 + u2\ x1\ y3 - u1\ \
x2\ y3\)\/\(x2\ y1 - x3\ y1 - x1\ y2 + x3\ y2 + x1\ y3 - x2\ y3\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a/c /. sol // FullSimplify\)], "Input"],

Cell[BoxData[
    \(\(u3\ x2\ y1 - u2\ x3\ y1 - u3\ x1\ y2 + u1\ x3\ y2 + u2\ x1\ y3 - u1\ \
x2\ y3\)\/\(\(-u2\)\ x1 + u3\ x1 + u1\ x2 - u3\ x2 - u1\ x3 + u2\ x3\)\)], \
"Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{520, 600},
WindowMargins->{{31, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 312, 6, 107, "Input"],
Cell[2054, 59, 457, 7, 127, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2548, 71, 57, 1, 27, "Input"],
Cell[2608, 74, 172, 2, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2817, 81, 59, 1, 27, "Input"],
Cell[2879, 84, 179, 3, 44, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

