/******************************************************************************
*
*  NSSDC/CDF	                                    Header file for CDFwalk.
*
*  Version 2.3, 12-Aug-96, Hughes STX.
*
*  Modification history:
*
*   V1.0  25-Jul-91, H Leckner  Original version (for CDF V2.1).
*   V1.1  11-Sep-91, J Love     Modified for IBM-PC port.
*   V1.2  15-Oct-91, H Leckner  Changed for IBM-RS6000 port.
*   V2.0  20-Apr-92, H Leckner  IBM PC port.  CDF V2.2.
*                    J Love
*   V2.1   2-Dec-93, H Leckner  CDF V2.4.
*   V2.1a  5-Apr-94, J Love     Function prototypes for Gnu C.
*   V2.2  13-Dec-94, J Love     CDF V2.5.
*   V2.2a  3-Apr-95, J Love	POSIX.
*   V2.2b 18-Apr-95, J Love	More POSIX.
*   V2.3  12-Aug-96, J Love	CDF V2.6.
*
******************************************************************************/

#if !defined(CDFWALKh_INCLUDEd__)
#define CDFWALKh_INCLUDEd__

/******************************************************************************
* Include files.
******************************************************************************/

#include "widgets.h"

#if defined(mac)
#include "cdfwalk.rh"
#endif

#define CDFparm         0

#define INITIALqual     0
#define SPECqual        1
#define CACHEqual       2
#define ABOUTqual       3

#define NOCONTINUE -10
#define PERIOD 46
#define DUPLICATE 0
#define OK_RESP -1
#define YES KB_Y
#define yes KB_y
#define NO  KB_N
#define no  KB_n
#define MINMAX_SIZE 15
#define EPOCH_WIDTH 25
#if defined(dos)
#define MAX_VALUES 500
#else
#define MAX_VALUES 5000
#endif
#define TERMINAL 1
#define FILEOUT  2
#define TERMFILE 3
#define CDFOUT   4
#define MINMAX 1
#define LIST   2
#define RINGBELL    -1
#define NOBELL  0
#define MENU 1
#define HELP_MENU 2
#define MIN_MAX_ERROR 0
#define SCALAR -1
#define INCREMENT 1
#define DECREMENT -1
#define DONE      0
#define MANUAL     0
#define AUTO       1
#define DIRECTory  2
#define NOPAUSE    0
#define PAUSE      1
#define WALK_FIELD 0
#define CDF_FIELD  1
#define SPECIAL_OPT_FIELD 2
#define RZ_FIELD 3
#define HELP_FIELD 4
#define EXIT       5
#define VARFORMAT_FIELD   1
#define ZERO_FIELD        2
#define NOTTHERE  -1
#define CDFWALK_MAX_VAR_LENGTH  8
#define CDFWALK_MAX_VARS_SCREEN  27
#define MULTIPLE  -1
#define FORMAT 1
#define NOFORMAT  2
#define CONVERT 1 
#define NOCONVERT 2
#define NODATA 9562 /* Random */
#define NOVARS 9563 /* Random */
#define RECORD 0
#define REGULAR   0
#define C       (*CDF)
#define NC      (*new_CDF)
#define S       (*screen)
#define V       variables[(int)var_num]
#define VN      (*variables)[(int)k][(int)index]
#define VA      variables[(int)var_num].attr[(int)attr_num]
#define SO      Special_options

struct GLOBAL_struct
{
	WINDOWid        CDF_vid;
	WINDOWid        VAR_vid;
	WINDOWid        KEY_vid;
	WINDOWid        MES_vid;
	WINDOWid        DIR_vid;
	WINDOWid        DIS_vid;
	WINDOWid        FIELD_vid;
	WINDOWid        DIM_vid;
	WINDOWid        HELP_vid;
	WINDOWid        WALK_vid;
	WINDOWid        VARSCROLL_vid;
	WINDOWid        SPECIAL_vid;
	WINDOWid        VARFORMAT_vid;
	WINDOWid        RZ_vid;
	WINDOWid        ZERO_vid;
};
struct vid_struct
{
	int             row;
	int             col;
	char            label[80];
};
struct variable_struct
{
	char            var_mnemonic[CDF_VAR_NAME_LEN+1];
	int             Z;
	long int        data_type;
	long int        num_bytes;
	long int        record_variance;
	long int        dim_variances[CDF_MAX_DIMS];
	long int        var_num;
	long int        out_var_num;
	double          min;
	double          max;
	long int        filter;
	long int        var_mnemonic_len;
	long int        scalar;
	long int        record_variable;
	long int        max_record_num;
	long int        dim_num;
	long int        dim_variable;
	long int        num_values;
	int             format;
	char            *format_value;
	long int        format_num_elements;
	CDFstatus       rcode;
	double          *bin_value;
	char            *char_value;
};
struct CDF_struct
{
	char                    CDF_name[CDF_PATHNAME_LEN];
	CDFid                   CDF_id;
	long int                *max_record_num;
	long int                total_vars;
	long int                num_ZCDF;
	long int                *num_dims;
	long int                **dim_sizes;
	long int                *num_vars;
	long int                numRvars;
	long int                numZvars;
	long int                num_attrs;
	long int                num_scalars;
	long int                max_var_len;
	long                    version;
	long                    release;
	char                    text[CDF_DOCUMENT_LEN];
	long                    encoding;
	long                    majority;
	long int                record_var_num;
	long int                EPOCH_var_num;
	long int                dim_var_num[CDF_MAX_DIMS];
	long int                **all_dim_var_num;
	long int                num_per_dim[CDF_MAX_DIMS+1];
	long int                first_scalar_var_num;
};
struct SPECIAL_OPTION_struct
{
	int                     variable_format;
	int                     format;
	int                     spec_entered;
	int                     zero;
	int                     curr_CDF;
};

union   mixed
{
	double                  r8;
	float                   r4;
	long int                i4;
	unsigned long int       ui4;
	short int               i2;
	unsigned short int      ui2;
	sChar                   byte;
	uChar                   ubyte;
	char                    *string;
};

#if defined(CDFWALK)
/*struct        EPOCH   ep;*/
struct  SPECIAL_OPTION_struct Special_options;
int firstForCDFname;
#else
/*extern struct EPOCH ep;*/
extern struct  SPECIAL_OPTION_struct Special_options;
extern int firstForCDFname;
#endif

/******************************************************************************
* Contents of 'cdfwalk_vid_def.h' start here.
******************************************************************************/

#define CDF_ROWS     4
#define CDF_COLUMNS 78
#define CDF_ROW_PASTE 0
#define CDF_COL_PASTE 0
#define CDF_NAME_ROW 1
#define CDF_NAME_COL 11
#define CDF_NAME_LENGTH 68
#define CDF_NUM_ELEMENTS 6
#define VAR_ROWS    9
#define VAR_COLUMNS 78
#define VAR_ROW_PASTE 6
#define VAR_COL_PASTE 0
#define VAR_NUM_ELEMENTS 54
#define VAR_MINMAX_LEN 14
#define VARSCROLL_ROWS    1
#define VARSCROLL_COLUMNS 36
#define VARSCROLL_ROW_PASTE 4
#define VARSCROLL_COL_PASTE 0
#define VARSCROLL_NUM_ELEMENTS 1
#define KEY_ROWS     2
#define KEY_COLUMNS 78
#define KEY_ROW_PASTE 17
#define KEY_COL_PASTE 0
#define KEY_NUM_ELEMENTS 1
#define MES_ROWS     1
#define MES_COLUMNS 78
#define MES_ROW_PASTE 21
#define MES_COL_PASTE 0
#define MES_NUM_ELEMENTS 1
#define WALK_COLUMNS 52
#define WALK_ROW_PASTE 0
#define WALK_COL_PASTE 0
#define FIELD_ROWS     6
#define FIELD_COLUMNS 22
#define FIELD_ROW_PASTE 0
#define FIELD_COL_PASTE 54
#define FIELD_NUM_ELEMENTS 6
#define DIM_ROWS     8
#define DIM_COLUMNS  10
#define DIM_ROW_PASTE 0
#define DIM_COL_PASTE 54
#define DIS_ROWS       8
#define DIS_COLUMNS   40
#define DIS_ROW_PASTE 0
#define DIS_COL_PASTE 36
#define DIR_ROWS      10
#define DIR_COLUMNS   27
#define DIR_ROW_PASTE 0
#define DIR_COL_PASTE 50
#define HELP_ROWS    10
#define HELP_COLUMNS 78
#define HELP_ROW_PASTE 4
#define HELP_COL_PASTE 0
#define SPECIAL_ROWS     14
#define SPECIAL_COLUMNS  69
#define SPECIAL_ROW_PASTE 1
#define SPECIAL_COL_PASTE 3
#define VARFORMAT_ROWS     2
#define VARFORMAT_COLUMNS 25
#define VARFORMAT_ROW_PASTE 6
#define VARFORMAT_COL_PASTE 10
#define VARFORMAT_NUM_ELEMENTS 2
#define RZ_ROWS    10
#define RZ_COLUMNS 25
#define RZ_ROW_PASTE 5
#define RZ_COL_PASTE 28 
#define ZERO_ROWS      2
#define ZERO_COLUMNS   19
#define ZERO_ROW_PASTE 6
#define ZERO_COL_PASTE 45
#define ZERO_NUM_ELEMENTS 2

#define CDFNAME_ELEMENT_NUM 1
#define NUMVAR_ELEMENT_NUM 2
#define NUMREC_ELEMENT_NUM 3
#define NUMDIM_ELEMENT_NUM 4
#define DIMSIZ_ELEMENT_NUM 5
#define BORDER_ROWS 2
#define BORDER_COLUMNS 2

/******************************************************************************
* Contents of 'cdfwalk_vid_init.h' start here.
******************************************************************************/

#if defined(CDFWALK)
struct  vid_struct      CDF_display[CDF_NUM_ELEMENTS] =
{
{  1,   2,   "CDF Name "},
{  4,   2,   "Number of Variables "},
{  2,  46,   "Number of Records "},
{  3,  43,   "Number of Dimensions "},
{  4,  48,   "Dimension Sizes "},
};
#else
extern struct   vid_struct      CDF_display[CDF_NUM_ELEMENTS];
#endif

#if defined(CDFWALK)
struct  vid_struct      KEY_display[KEY_NUM_ELEMENTS] =
{
{  1,  1,   ""},
};
#else
extern struct   vid_struct      KEY_display[KEY_NUM_ELEMENTS];
#endif

#if defined(CDFWALK)
struct  vid_struct      MES_display[MES_NUM_ELEMENTS] =
{
{  1,  1,   ""},
};
#else
extern struct   vid_struct      MES_display[MES_NUM_ELEMENTS];
#endif

#if defined(CDFWALK)
struct  vid_struct      VARSCROLL_display[VARSCROLL_NUM_ELEMENTS] =
{
{  1,  1,   "Variable Scroller, direction ==> ?"},
};
#else
extern struct   vid_struct      VARSCROLL_display[VARSCROLL_NUM_ELEMENTS];
#endif

#if defined(CDFWALK)
struct  vid_struct      FIELD_display[FIELD_NUM_ELEMENTS] =
{
{  1,   1,  "Walk Thru CDF data    "},
{  2,   1,  "Select Input CDF Name "},
{  3,   1,  "Select Special Options"},
{  4,   1,  "Select R/Z Variables  "},
{  5,   1,  "Help                  "},
{  6,   1,  "Exit                  "},
};
#else
extern struct   vid_struct      FIELD_display[FIELD_NUM_ELEMENTS];
#endif
#if defined(CDFWALK)
struct  vid_struct      VARFORMAT_display[VARFORMAT_NUM_ELEMENTS] =
{
{  1,   1,  "( ) CDF FORMAT attribute"},
{  2,   1,  "( ) CDFWALK defaults    "},
};
struct  vid_struct      ZERO_display[ZERO_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Convert -0.0  "},
{  2,   1,  "( ) Ignore  -0.0  "},
};
#else
extern struct vid_struct VARFORMAT_display[VARFORMAT_NUM_ELEMENTS];
extern struct vid_struct ZERO_display[ZERO_NUM_ELEMENTS];
#endif



#if defined(CDFWALK)
FILE    *HELP_ptr;
char    *print_string;
#else
extern FILE     *HELP_ptr;
extern char     *print_string;
#endif

#if defined(CDFWALK)
static char             WALK_label[] =
"Variable                    Value Record/Dim#  Index";
static char             WALK_EPOCH_label[] =
"Variable DD-MON-YYYY HH:MM:SS.MSC Record/Dim#  Index";
#endif

#if !defined(CDFWALK)
static char             SPECIAL_label[] = "CDFWALK Special Options";
static char             VARFORMAT_label[] = "Variable display format";
static char             ZERO_label[] = "Zero conversion";
#endif



#if defined(vms)
static char default_name[] = "[]";
#endif

#if defined(unix) || defined(posixSHELL)
static char default_name[] = "./";
#endif

#if defined(dos)
static char default_name[] = ".\\";
#endif

#if defined(mac)
static char default_name[] = ":";
#endif

Logical WalkCDFs PROTOARGs((int argC, char *argV[]));
Logical WalkQOPs PROTOARGs((int *argC, char **argV[]));

long int print_error PROTOARGs((struct GLOBAL_struct *screen,
				CDFstatus rcode));
int alloc_all_dim PROTOARGs((long int ***ptr, long int num_vars,
			     long int num_dims));
int load_all_dim PROTOARGs((struct CDF_struct *CDF,
			    struct  variable_struct *variables));
void free_all_dim PROTOARGs((long int **ptr, long int num_dims));
long which_cdf PROTOARGs((long num_ZCDF, long num_dims, long *ds,
			  long *all_num_dims, long **all_dim_sizes));
CDFstatus load_sizes PROTOARGs((struct CDF_struct *CDF));
CDFstatus alloc_sizes PROTOARGs((long int **numDims, long int ***dim_sizes,
				 long int **num_vars,
				 long int **max_record_num,
				 long int numZvars));
CDFstatus alloc_vars PROTOARGs((struct variable_struct ***variables,
				long int numZCDF, long int numRvars,
				long int numZvars));
CDFstatus CDFWALK_open PROTOARGs((struct CDF_struct *CDF,
				  struct variable_struct ***variables,
				  union mixed **data_values));
void CDFWALK_load_dim PROTOARGs((struct CDF_struct *CDF,
				 struct variable_struct *variables,
				 struct vid_struct *DIM_display,
				 long int dim_num, int *num_rows));
void CDFWALK_list PROTOARGs((struct GLOBAL_struct *screen,
			     struct CDF_struct *CDF,
			     struct variable_struct *variables,
			     struct vid_struct *VAR_display,
			     union mixed *data_values, long int *curr_field));
void CDFWALK_scroll_var PROTOARGs((struct GLOBAL_struct *screen,
				   struct CDF_struct *CDF,
				   struct variable_struct *variables,
				   struct vid_struct *VAR_display,
				   long int *var_index,
				   union mixed data_values[],
				   long int *field_num));
void CDFWALK_print_data PROTOARGs((struct GLOBAL_struct *screen,
				   struct variable_struct *select,
				   struct vid_struct *VAR_display,
				   long int field_num,
				   long int var_num,
				   union mixed data_values[],
				   int walker_only));
void remove_trail PROTOARGs((char *str));
void CDFWALK_load_var PROTOARGs((struct GLOBAL_struct *screen,
				 struct CDF_struct *CDF,
				 struct variable_struct *variables,
				 struct vid_struct *VAR_display,
				 long int index,
				 union mixed data_values[]));
void CDFWALK_get_data PROTOARGs((struct CDF_struct *CDF,
				 struct variable_struct select[],
				 long int num_select,
				 long int record_num,
				 long int indices[],
				 union mixed data_values[]));
void CDFWALK_alloc_STRING PROTOARGs((struct variable_struct select[],
				     long int num_select,
				     union mixed data_values[]));
void CDFWALK_free_STRING PROTOARGs((struct variable_struct select[],
				    long int num_select,
				    union mixed data_values[]));
void CDFWALK_free_discrete PROTOARGs((struct variable_struct *select,
				      long int num_select));
int init_var_display PROTOARGs((struct vid_struct **display));
void CDFWALK_walk_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_help_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_CDFname_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_Menu_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_special_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_scroll_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_load_discrete PROTOARGs((char values[], long int num_values,
				      long int num_bytes,
				      struct vid_struct *DIS_display,
				      int *num_rows, int *num_cols));
void CDFWALK_get_EPOCH PROTOARGs((CDFid CDF_id, int Z, long int var_num,
				  long int max_record_num, double bin_values[],
				  char *char_values));
void CDFWALK_get_discrete PROTOARGs((CDFid CDF_id, int Z, long int dim_num,
				     long int var_id, long int data_type,
				     long int num_values, double bin_values[],
				     char *char_values));
void CDFWALK_get_discrete_char PROTOARGs((CDFid CDF_id, int Z,
					  long int dim_num, long int var_num,
					  long int num_values,
					  long int num_bytes,
					  char *char_values));
void CDFWALK_clear_row PROTOARGs((WINDOWid vid, struct vid_struct display[],
				  int start_elem, int end_elem, int end_col));
void CDFWALK_help PROTOARGs((struct GLOBAL_struct *screen));
int lastc PROTOARGs((char *buf));
void CDFWALK_field_menu PROTOARGs((struct GLOBAL_struct *screen, CDFid CDF_id,
				   long int *option));
void CDFWALK_open_screen PROTOARGs((struct GLOBAL_struct *screen));
void CDFWALK_special_options PROTOARGs((struct GLOBAL_struct *screen,
					CDFid CDF_id));
int CDFWALK_special_option_menu PROTOARGs((WINDOWid vid, int *value,
					   int num_rows));
void CDFWALK_disp_opt PROTOARGs((WINDOWid vid, int value, int num_rows));
void NEG_to_POS PROTOARGs((CDFid CDF_id));
#if defined(dos)
void CDFWALK_draw_main_screen PROTOARGs((struct GLOBAL_struct *screen,
					 long int WALK, long int EPOCH));
#endif
void CDFWALK_select_menu_item PROTOARGs((WINDOWid vid, WINDOWid MES_vid,
					 long int *rvalue,
					 struct vid_struct display[],
					 int num_elements, int num_rows,
					 int num_columns, int row_start,
					 int col_start, int mode,
					 int *termcode));
int CDFWALK_CDF_name PROTOARGs((struct GLOBAL_struct *screen,
				struct CDF_struct *CDF, long int *field_num,
				long int *input_type));
CDFstatus CDFWALK_select_RZ PROTOARGs((struct GLOBAL_struct *screen,
				       struct CDF_struct *CDF, int *tcode));
void CDFWALK_CDF_info PROTOARGs((struct GLOBAL_struct *screen,
				 struct CDF_struct *CDF,
				 struct vid_struct CDF_display[]));
void load_vid PROTOARGs((WINDOWid vid, struct vid_struct display[],
			 int start_element, int num_elements, char label[]));
void load_vid_element PROTOARGs((WINDOWid vid, struct vid_struct display[],
				 int element_num));
void CDFWALK_load_keydef PROTOARGs((WINDOWid vid, char line1[], char line2[]));
void CDFWALK_put_selection PROTOARGs((WINDOWid vid,
				      struct vid_struct display[],
				      int element_num, char selection[],
				      int field_len, int video_type));
void CDFWALK_put_value PROTOARGs((WINDOWid vid, struct vid_struct display[],
				  int element_num, double bin_value));
void CDFWALK_put_message PROTOARGs((WINDOWid vid, char message[], int rbell,
				    int video_type, int pause));
void load_menu PROTOARGs((WINDOWid vid, struct vid_struct display[],
			  int num_elements, char label[]));
void zero_replace PROTOARGs((char string[]));
void CDFWALK_left_justify PROTOARGs((char field[]));
int precision PROTOARGs((double num));
CDFstatus CDFWALK_close PROTOARGs((struct CDF_struct *CDF,
				   struct variable_struct **variables));
void CDFWALK_close_screen PROTOARGs((void));
double r4_r8 PROTOARGs((float *r4));
long int CDFWALK_get_index PROTOARGs((CDFid CDF_id, long int Z,
				      long int dim_num, long int var_num,
				      double value, long int data_type,
				      double dim_values[],
				      long int num_values));
long int CDFWALK_get_index_char PROTOARGs((CDFid CDF_id, long int Z,
					   long int dim_num,
					   long int var_num, char *value,
					   long int num_bytes,
					   char dim_values[],
					   long int num_values));
void make_it_upper PROTOARGs((char *upstring, char *string));
long int how_many_match PROTOARGs((char *str1, char *str2));
double check_epoch PROTOARGs((char str[]));

#if defined(CDFWALK)
char            VAR_label[] = "Variable Selection";
char            KEY_label[] = "Keypad Definitions";
char            MES_label[] = "Message Buffer";
char            NO_label[] = "";
#else
extern char             VAR_label[];
extern char             KEY_label[];
extern char             MES_label[];
extern char             NO_label[];
#endif

#endif
