/******************************************************************************
*
*  NSSDC/CDF	                                    Header file for CDFlist.
*
*  Version 2.7, 1-Apr-96, Hughes STX.
*
*  Modification history:
*
*   V1.0  29-Jan-91, H Leckner    Original version (for CDF V2.0).
*   V1.1  26-Mar-91, H Leckner    Fix for possible char array overwrite.
*   V1.2  25-Jun-91, H Leckner    CDF V2.1 enhancements.  'cdflist_vid_def.h'
*                                 and 'cdflist_vid_init.h' included.
*   V1.3   9-Jul-91, H Leckner    Fix for filters.
*   V1.4  11-Sep-91, J Love       Modified for IBM-PC port.
*   V1.5   4-Oct-91, H Leckner    Added ability to select more than 8 vars.
*   V1.6  15-Oct-91, H Leckner    Changed for Curses on IBM-RS6000.
*   V1.7  05-Nov-91, H Leckner    Changed for IBM-PC, also added function
*                                 protoypes.
*   V2.0  30-Apr-92, H Leckner    IBM PC port (and HP 9000).  CDF V2.2.
*   V2.1   9-Jun-92, H Leckner    Output to file fix.  `Dump' option.
*   V2.1a 14-Jul-92, J Love       | --> ||.
*   V2.2  24-Jan-94, H Leckner    CDF V2.4.
*   V2.2a  4-Feb-94, J Love       DEC Alpha/OpenVMS port.
*   V2.3   5-Apr-94, H Leckner    Use CDF Hyper call for CDF output.  Function
*                    J Love       prototypes for Gnu C.
*   V2.4   6-Dec-94, J Love       CDF V2.5.
*   V2.5   8-Feb-95, H Leckner    I don't know.
*   V2.6   3-Apr-95, J Love	  POSIX.
*   V2.6a 18-Apr-95, J Love	  More POSIX.
*   V2.6b  4-Aug-95, J Love	  CDFexport-related changes.
*   V2.7   1-Apr-96, J Love	  CDF V2.6.
*
******************************************************************************/

#if !defined(CDFLISTh_INCLUDEd__)
#define CDFLISTh_INCLUDEd__

/******************************************************************************
* Include files.
******************************************************************************/

#include "widgets.h"

#if defined(mac)
#include "cdflist.rh"
#endif

#define CDFparm         0

#define DUMPqual        0
#define OUTPUTqual      1
#define INITIALqual     2
#define SPECqual        3
#define CACHEqual       4
#define ABOUTqual       5

#define NOCONTINUE -10
#define PERIOD 46
#define DUPLICATE 0
#define MIN_GT_MAX 1
#define BAD_MALLOC_READ_VAR -1
#define OK_RESP -1
#define ZPASS 1
#define REGMODE 0
#define ZMODE 1
#define DECREASE -1
#define INCREASE 1
#define NOVARS 9563 /* Random */
#define RECORD_VAR_NUM 9564 /* Random */
#define RECORD_VAR 1
#define NODATA -123
#define YES KB_Y
#define yes KB_y
#define NO  KB_N
#define no  KB_n
#define MINMAX_SIZE 15
#define EPOCH_WIDTH 25
#define AUTO_DUMP 1
#define TERMIN 1
#define FILEOUT  2
#define TERMFILE 3
#define CDFOUT   4
#define MINMAX 1
#define LIST   2
#define NOERASEVARS 2
#define ERASEVARS   1
#define RINGBELL    -1
#define NOBELL  0
#define MENU 1
#define HELP_MENU 2
#define MONOTONIC 3
#define MIN_MAX_ERROR 0
#define SCALAR -1
#define LESS_THAN    -1
#define IN_RANGE      0
#define GREATER_THAN  1
#define FILTER_ON   1
#define FILTER_OFF -1
#define SELECT_ALL 1
#define MIN_MAX   1
#define MIN_ONLY  2
#define MAX_ONLY  3
#define DONE      0
#define MANUAL     0
#define AUTO       1
#define DIRECTory  2
#define NOPAUSE    0
#define PAUSE      1
#define SHORTPAUSE 2
#define LIST_DATA      0
#define CDF_FIELD      1
#define OUT_FIELD      2
#define VAR_FIELD      3
#define MONOTON_FIELD  4
#define SAVE_FIELD     5
#define RESTORE_FIELD  6
#define RZ_FIELD       7  
#define INOPT_FIELD    8
#define OUTOPT_FIELD   9
#define LISTOPT_FIELD 10
#define HELP_FIELD    11
#define EXIT          12
#define FILEFORM_FIELD 1
#define ENCODING_FIELD 2
#define ERASEVAR_FIELD 1
#define EPOCHFORMAT_FIELD 1
#define VARFORMAT_FIELD   2
#define FILTER_FIELD      3
#define FILLVALUE_FIELD   4
#define PRINTMODE_FIELD   5
#define ZERO_FIELD        6
#define CDFNAME_ELEMENT_NUM 1
#define NUMDIM_ELEMENT_NUM 2
#define DIMSIZ_ELEMENT_NUM 3
#define NUMVAR_ELEMENT_NUM 4
#define NUMREC_ELEMENT_NUM 5
#define OUT_ELEMENT_NUM    6
#define OUT_NAME_ELEMENT_NUM  7
#define NUM_HORIZ_FIELDS 4
#define VERTICAL 1
#define HORIZONTAL 2
#define FILL -1
#define OUT_OF_RANGE 0
#define NORMAL_PRINT 1
#define NOTTHERE  -1
#define CDFLIST_MAX_VAR_LENGTH  19
#define MAX_FILE_NAME_LEN 31
#define MAX_FILE_NAME_DISPLAY_LEN 14
#define MULTIPLE  -1
#define ZMODE_ROW 2
#define ZMODE_COL 57
#define EPOCHFORM_DEF     1
#define EPOCHFORM_1       2
#define FORMAT 1
#define NOFORMAT  2
#define FILTER     1
#define NOFILTER   2
#define NOCHECK_FILL   2
#define CHECK_FILL     1
#define REGULAR   0
#define NONDISPLAY 0
#define DISPLAY    1
#define NO_HYPER  0
#define HYPER     1
#define NET     1
#define HOST    2
#define SINGLEF 1
#define MULTIF  2
#define CONVERT 1 
#define NOCONVERT 2
#define RECORD_NUMBER 1 
#if defined(dos)
#define MAX_VALUES 1000
#define MAX_ARRAY_SIZE 64000L
#else
#define MAX_VALUES 100000
#endif
#define C       (*CDF)
#define NC      (*new_CDF)
#define S       (*screen)
#define V       variables[var_num]
#define VA      variables[var_num].attr[attr_num]

#define SO      Special_options
struct GLOBAL_struct
{
	WINDOWid        SCREEN_vid;
	WINDOWid        save_id;
	WINDOWid        CDF_vid;
	WINDOWid        VAR_vid;
	WINDOWid        KEY_vid;
	WINDOWid        MES_vid;
	WINDOWid        OUT_vid;
	WINDOWid        VARSELECT_vid;
	WINDOWid        DIR_vid;
	WINDOWid        DIS_vid;
	WINDOWid        FIELD_vid;
	WINDOWid        HELP_vid;
	WINDOWid        SPECIAL_vid;
	WINDOWid        EPOCHFORMAT_vid;
	WINDOWid        VARFORMAT_vid;
	WINDOWid        MINMAX_vid;
	WINDOWid        FILTER_vid;
	WINDOWid        FILLVALUE_vid;
	WINDOWid        ERASEVAR_vid;
	WINDOWid        PRINTMODE_vid;
	WINDOWid        FILEFORM_vid;
	WINDOWid        ENCODING_vid;
	WINDOWid        ZERO_vid;
	WINDOWid        RZ_vid;
	WINDOWid        VAR_MONOTON_vid;
};
struct vid_struct
{
	int             row;
	int             col;
	char            label[80];
	int             field_col;
};

struct  group
{
	long            num_dims;
	long            dim_sizes[CDF_MAX_DIMS];
	long            num_vars;
	long            max_record_num;
	long            values_per_record;
	long            PhyDimValues[CDF_MAX_DIMS];
	struct  VAR_struct    *first_var;
	struct  VAR_struct    *curr_var;
	struct  group   *next_group;
};

struct attr_struct
{
	char            attr_mnemonic[CDF_ATTR_NAME_LEN+1];
	long int        data_type;
	long int        num_elements;
	long int        maxGentry;
/*      long int        maxZentry; */
	long int        attr_scope;
};
struct VAR_struct
{
	char            var_mnemonic[CDF_VAR_NAME_LEN+1];
	int             Z;
	long int        data_type;
	long int        num_bytes;
	long int        record_variance;
	long int        dim_variances[CDF_MAX_DIMS];
	long int        var_num;
	long int        out_var_num;
	double          min;
	double          max;
	double          filter_min;
	double          filter_max;
	int             filter;
	long int        first_record;
	long int        last_record;
	int             restore;
	int             display;
	int             out_select_num;
	int             minmax_flag[2];
	int             var_mnemonic_len;
	char            header_name[80];
	int             scalar;
	int             scalar_entered;
	int             dim_num;
	long int        num_values;
	long int        num_values_out;
	long int        max_values;
	long int        total_values;
	long int        x[CDF_MAX_DIMS];
	long int        var_num_dims;
	long int        act_dim_sizes[CDF_MAX_DIMS];
	long int        var_sizes[CDF_MAX_DIMS];
	long int        PhyDimValues[CDF_MAX_DIMS];
	long int        fillval_attr_num;
	int             fillval;
	double          fill_value;
	double          fill_value_min;
	double          fill_value_max;
	int             format;
	char            *format_value;
	int             monoton;
	char            *monoton_value;
	int             field_width;
	void            *pad_value;
	CDFstatus       rcode;
	int             discrete;
	int             multidim;
	int             copy_complete;
	double          *bin_value;
	char            *char_value;
	void            *data_array;
	void            *data_array_out;
	int             bytes_value;
	int             cnt;
	int             offset;
	struct VAR_struct     *next_var;
};
struct CDF_struct
{
	char                    CDF_name[CDF_PATHNAME_LEN];
	CDFid                   CDF_id;
	struct  group           *first_group;
	struct  group           *curr_group;
	struct  group           *zmode_group;
	long int                *max_record_num;
	long int                total_vars;
	int                     num_groups;
	long                    select_num_dims;
	long                    select_dim_sizes[CDF_MAX_DIMS];
	long                    select_PhyDimValues[CDF_MAX_DIMS];
	long                    select_values_per_record;
	long int                CDF_form;
	long int                numRvars;
	long int                numZvars;
	long int                num_attrs;
	int                     output;
	long int                max_var_len;
	long int                fillval_attr_num;
	long                    version;
	long                    release;
	char                    text[CDF_DOCUMENT_LEN];
	long                    encoding;
	long                    majority;
	long                    first_indice[CDF_MAX_DIMS];
	long                    last_indice[CDF_MAX_DIMS];
	char                    file_name[MAX_FILE_NAME_LEN+4+1]; 
					/*add 4 for extension 1 for \0 */
	struct attr_struct      *attr;
};
struct SPECIAL_OPTION_struct
{
	int                     EPOCH_format;
	int                     EPOCH_output_len[2];
	int                     variable_format;
	int                     format;
	int                     filters;
	int                     fill_values;
	int                     fillval;
	int                     minmax;
	int                     monoton;
	int                     erasevars;
	int                     mode;
	int                     curr_CDF;
	int                     list_mode;
	int                     print_mode;
	int                     hyper;
	int                     hyper_out;
	int                     encoding;
	int                     file_form;
	int                     spec_entered;
	int                     zero;
};

union   mixed
{
	double                  r8;
	float                   r4;
	long int                i4;
	unsigned long int       ui4;
	short int               i2;
	unsigned short int      ui2;
	sChar                   byte;
	uChar                   ubyte;
	char                    *string;
};
#if defined(CDFLIST)
struct  SPECIAL_OPTION_struct Special_options;
#else
extern struct  SPECIAL_OPTION_struct Special_options;
#endif

/******************************************************************************
* Contents of 'cdflist_vid_def.h' start here.
******************************************************************************/
#define SCREEN_ROWS     24
#define SCREEN_COLUMNS  80
#define SCREEN_ROW_PASTE 0
#define SCREEN_COL_PASTE 0
#define CDF_ROWS     4
#define CDF_COLUMNS 78
#define CDF_ROW_PASTE 0
#define CDF_COL_PASTE 0
#define CDF_NAME_ROW 1
#define CDF_NAME_COL 11
#define CDF_NAME_LENGTH 68
#define CDF_NUM_ELEMENTS 7
#define VAR_ROWS    9
#define VAR_COLUMNS 78
#define VAR_ROW_PASTE 6
#define VAR_COL_PASTE 0
#define VAR_NUM_ELEMENTS 36
#define VAR_MINMAX_LEN 14
#define KEY_ROWS     2
#define KEY_COLUMNS 78
#define KEY_ROW_PASTE 17
#define KEY_COL_PASTE 0
#define KEY_NUM_ELEMENTS 1
#define MES_ROWS     1
#define MES_ROW_PASTE 21
#define SR_OFFSET 0
#define MES_COLUMNS 78-SR_OFFSET
#define MES_COL_PASTE 0
#define MES_NUM_ELEMENTS 1
#define OUT_ROWS     4
#define OUT_COLUMNS 13
#define OUT_ROW_PASTE 4
#define OUT_COL_PASTE 62
#define OUT_NUM_ELEMENTS 4
#define OUT_NAME_ROW 1
#define OUT_NAME_COL 34
#define OUT_NAME_LEN MAX_FILE_NAME_LEN
#define FIELD_ROWS     13
#define FIELD_COLUMNS 27
#define FIELD_ROW_PASTE 1
#define FIELD_COL_PASTE 28
#define FIELD_NUM_ELEMENTS 13
#define DIS_ROWS       8
#define DIS_COLUMNS   16
#define DIS_ROW_PASTE 7
#define DISMIN_COL_PASTE 24
#define DISMAX_COL_PASTE 50
#define DIR_ROWS      10
#define DIR_COLUMNS   27
#define DIR_ROW_PASTE 0
#define DIR_COL_PASTE 50
#define EPOCH_ROWS      1
#define EPOCH_COLUMNS   24
#define EPOCH_ROW_PASTE 6
#define EPOCH_NUM_ELEMENTS 1
#define VARSELECT_ROWS      8
#define VARSELECT_COLUMNS   58
#define VARSELECT_ROW_PASTE 7
#define VARSELECT_COL_PASTE 18
#define VARSELECT_NUM_ELEMENTS 8
#define HELP_ROWS    10
#define HELP_COLUMNS 78
#define HELP_ROW_PASTE 4
#define HELP_COL_PASTE 0
#define RZ_ROWS    10
#define RZ_COLUMNS 25
#define RZ_ROW_PASTE 5
#define RZ_COL_PASTE 28
#define SPECIAL_ROWS     14
#define SPECIAL_COLUMNS  69
#define SPECIAL_ROW_PASTE 1
#define SPECIAL_COL_PASTE 3
#define EPOCHFORMAT_ROWS     2
#define EPOCHFORMAT_COLUMNS 29
#define EPOCHFORMAT_ROW_PASTE 3
#define EPOCHFORMAT_COL_PASTE 7
#define EPOCHFORMAT_NUM_ELEMENTS 2
#define VARFORMAT_ROWS     2
#define VARFORMAT_COLUMNS 25
#define VARFORMAT_ROW_PASTE 3
#define VARFORMAT_COL_PASTE 42
#define VARFORMAT_NUM_ELEMENTS 2
#define FILTER_ROWS     2
#define FILTER_COLUMNS 26
#define FILTER_ROW_PASTE 8
#define FILTER_COL_PASTE 7
#define FILTER_NUM_ELEMENTS 2
#define FILLVALUE_ROWS     2
#define FILLVALUE_COLUMNS 28
#define FILLVALUE_ROW_PASTE 8
#define FILLVALUE_COL_PASTE 42
#define FILLVALUE_NUM_ELEMENTS 2
#define ERASEVAR_ROWS     2
#define ERASEVAR_COLUMNS 26
#define ERASEVAR_ROW_PASTE 7
#define ERASEVAR_COL_PASTE 25
#define ERASEVAR_NUM_ELEMENTS 2
#define PRINTMODE_ROWS     2
#define PRINTMODE_COLUMNS 18
#define PRINTMODE_ROW_PASTE 12
#define PRINTMODE_COL_PASTE 7
#define PRINTMODE_NUM_ELEMENTS 2
#define FILEFORM_ROWS     2
#define FILEFORM_COLUMNS 17
#define FILEFORM_ROW_PASTE 7
#define FILEFORM_COL_PASTE 15
#define FILEFORM_NUM_ELEMENTS 2
#define ENCODING_ROWS     2
#define ENCODING_COLUMNS 19
#define ENCODING_ROW_PASTE 7
#define ENCODING_COL_PASTE 43
#define ENCODING_NUM_ELEMENTS 2
#define ZERO_ROWS      2
#define ZERO_COLUMNS   19
#define ZERO_ROW_PASTE 12
#define ZERO_COL_PASTE 42
#define ZERO_NUM_ELEMENTS 2

#define BORDER_ROWS 2
#define BORDER_COLUMNS 2


/******************************************************************************
* Contents of 'cdflist_vid_init.h' start here.
******************************************************************************/
#if defined(CDFLIST)
struct  vid_struct      CDF_display[CDF_NUM_ELEMENTS] =
{
{  1,   2,   "CDF Name ", 11 },
{  3,   2,   "Number of Dimensions ", 23},
{  4,   2,   "Dimension Sizes ", 18},
{  3,  29,   "Number of Variables ",49},
{  4,  29,   "Number of Records ", 47},
{  3,  57,   "Output ",64},
{  4,  54,   "File name ",64},
};
#else
extern struct vid_struct        CDF_display[CDF_NUM_ELEMENTS];
#endif

#if defined(CDFLIST)
struct  vid_struct         init_display[VAR_NUM_ELEMENTS];
#else
extern struct  vid_struct  init_display[VAR_NUM_ELEMENTS];
#endif

#if defined(CDFLIST)
struct  vid_struct      KEY_display[KEY_NUM_ELEMENTS] =
{
{  1,  1,   "", 1},
};
#else
extern struct  vid_struct       KEY_display[KEY_NUM_ELEMENTS];
#endif

#if defined(CDFLIST)
struct  vid_struct      MES_display[MES_NUM_ELEMENTS] =
{
{  1,  1,   "", 1},
};
#else
extern struct vid_struct        MES_display[MES_NUM_ELEMENTS];
#endif

#if defined(CDFLIST)
struct  vid_struct      OUT_display[OUT_NUM_ELEMENTS] =
{
{  1,   1,  "Terminal     ",1},
{  2,   1,  "File         ",1},
{  3,   1,  "Terminal/File",1},
{  4,   1,  "CDF          ",1},
};
#else
extern struct  vid_struct               OUT_display[OUT_NUM_ELEMENTS];
#endif
#if defined(CDFLIST)
struct  vid_struct      FIELD_display[FIELD_NUM_ELEMENTS] =
{
{  1,   1,  "Generate Output            ",1},
{  2,   1,  "Select Input CDF Name      ",1},
{  3,   1,  "Select Output Device       ",1},
{  4,   1,  "Select Variables           ",1},
{  5,   1,  "Specify Monotonic Variables",1},
{  6,   1,  "Save Variables to file     ",1},
{  7,   1,  "Restore Variables from file",1},
{  8,   1,  "Select r/z/zMODE Variables ",1},
{  9,   1,  "Select CDF Input Options   ",1},
{  10,  1,  "Select CDF Output Options  ",1},
{  11,  1,  "Select CDF Listing Options ",1},
{  12,  1,  "Help                       ",1},
{  13,  1,  "Exit                       ",1},
};
#else
extern struct vid_struct FIELD_display[FIELD_NUM_ELEMENTS];
#endif
#if defined(CDFLIST)
struct  vid_struct      EPOCHFORMAT_display[EPOCHFORMAT_NUM_ELEMENTS] =
{
{  1,   1,  "( ) DD-MMM-YYYY HH:MM:SS.MSC",1},
{  2,   1,  "( ) YYYYMMDD.TTTTTTT        ",1},
};
struct  vid_struct      VARFORMAT_display[VARFORMAT_NUM_ELEMENTS] =
{
{  1,   1,  "( ) CDF FORMAT attribute",1},
{  2,   1,  "( ) CDFLIST defaults    ",1},

};
struct  vid_struct      FILTER_display[FILTER_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Use    min/max values",1},
{  2,   1,  "( ) Ignore min/max values",1},
};
struct  vid_struct      FILLVALUE_display[FILLVALUE_NUM_ELEMENTS] =
{
{  1,   1,  "( )     Display Fill values",1},
{  2,   1,  "( ) non-Display Fill Values",1},
};
struct  vid_struct      ERASEVAR_display[ERASEVAR_NUM_ELEMENTS] =
{
{  1,   1,  "( )       Erase variables",1},
{  2,   1,  "( ) Don't Erase variables",1},
};
struct  vid_struct      PRINTMODE_display[PRINTMODE_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Vertical      ",1},
{  2,   1,  "( ) Horizontal    ",1},
};
struct  vid_struct      FILEFORM_display[FILEFORM_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Single      ",1},
{  2,   1,  "( ) Multi       ",1},
};
struct  vid_struct      ENCODING_display[ENCODING_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Network       ",1},
{  2,   1,  "( ) Host          ",1},
};
struct  vid_struct      ZERO_display[ZERO_NUM_ELEMENTS] =
{
{  1,   1,  "( ) Convert -0.0  ",1},
{  2,   1,  "( ) Ignore  -0.0  ",1},
};

#else
extern struct vid_struct EPOCHFORMAT_display[EPOCHFORMAT_NUM_ELEMENTS];
extern struct vid_struct VARFORMAT_display[VARFORMAT_NUM_ELEMENTS];
extern struct vid_struct FILTER_display[FILTER_NUM_ELEMENTS];
extern struct vid_struct FILLVALUE_display[FILLVALUE_NUM_ELEMENTS];
extern struct vid_struct ERASEVAR_display[ERASEVAR_NUM_ELEMENTS];
extern struct vid_struct PRINTMODE_display[PRINTMODE_NUM_ELEMENTS];
extern struct vid_struct FILEFORM_display[FILEFORM_NUM_ELEMENTS];
extern struct vid_struct ENCODING_display[ENCODING_NUM_ELEMENTS];
extern struct vid_struct ZERO_display[ZERO_NUM_ELEMENTS];
#endif

#define KEY_label               "Keypad Definitions"
#define MES_label               "Message Buffer"
#define NO_label                ""
#define INOPT_label             "CDFLIST CDF Input Options"
#define ERASEVAR_label          "Erase Variables"
#define OUTOPT_label            "CDFLIST CDF Output Options"
#define FILEFORM_label          "CDF Output format"
#define ENCODING_label          "CDF Output encoding"
#define LISTOPT_label           "CDFLIST CDF Listing Options"
#define EPOCHFORMAT_label       "EPOCH display format"
#define VARFORMAT_label         "Variable display format"
#define FILTER_label            "Filtering"
#define FILLVALUE_label         "Fill Values"
#define PRINTMODE_label         "zMODE listing type"
#define ZERO_label              "Zero conversion"

#if defined(CDFLIST)
FILE    *HELP_ptr;
char    *print_string;
int     FILE_is_OPEN;
char            VAR_label[] = "Variable Selection";
int firstForCDFname;
#else
extern FILE     *HELP_ptr;
extern char     *print_string;
extern int      FILE_is_OPEN;
extern char             VAR_label[];
extern int firstForCDFname;
#endif

#if defined(CDFLIST)
#if defined(vms)
static char default_spec[] = "[]";
#endif
#if defined(unix) || defined(posixSHELL)
static char default_spec[] = "./";
#endif
#if defined(dos)
static char default_spec[] = ".\\";
#endif
#if defined(mac)
static char default_spec[] = ":";
#endif
#endif

Logical ListCDFs PROTOARGs((int argC, char *argV[]));
Logical ListQOPs PROTOARGs((int *argC, char **argV[]));

void init_var_display PROTOARGs((struct vid_struct *display,
				 long int num_vars));
double check_epoch PROTOARGs((char str[]));
int precision PROTOARGs((double num));
void CDFLIST_save_screen PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_restore_screen PROTOARGs((struct GLOBAL_struct *screen));
int CDFLIST_CDF_name PROTOARGs((struct GLOBAL_struct *screen,
				struct CDF_struct *CDF, int *field_num,
				int *input_type));
int get_var_num PROTOARGs((struct VAR_struct *possible, char *mnemonic,
			   long int num_poss));
struct VAR_struct *var_load PROTOARGs((struct VAR_struct *possible, int var_num));
void record_display_format PROTOARGs((struct VAR_struct *VN, long record_num));
void header PROTOARGs((struct VAR_struct *VN, int squeeze));
int print_error PROTOARGs((struct GLOBAL_struct *screen, CDFstatus rcode));
int which_cdf PROTOARGs((long num_dims, long *ds, struct group *first_group));
CDFstatus load_sizes PROTOARGs((struct CDF_struct *CDF));
CDFstatus alloc_sizes PROTOARGs((long int **numDims, long int ***dim_sizes,
				 long int **num_vars,
				 long int **max_record_num,
				 long int numZvars));
struct group *load_group PROTOARGs((struct group *first_group, int num,
				    int num_poss));
struct VAR_struct *create_record_var PROTOARGs((struct CDF_struct *CDF, 
					 struct group *curr_group, int Z));
CDFstatus CDFLIST_open PROTOARGs((struct CDF_struct *CDF,
				  union mixed **data_values));
CDFstatus alloc_VAR_display PROTOARGs((struct vid_struct **VAR_display,
				       long int num_vars));
CDFstatus alloc_filters PROTOARGs((int **filters, long int num_vars));
int scalar_check PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *select,
			    long int record_num, union mixed *data_values));
void CDFLIST_get_data PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *select,
				 long int num_select, long int record_num,
				 long int indices[],
				 union mixed *data_values));
CDFstatus CDFLIST_alloc_STRING PROTOARGs((struct VAR_struct *select,
					  long int num_select,
					  union mixed *data_values));
void CDFLIST_free_STRING PROTOARGs((struct VAR_struct *select, long int num_select,
				    union  mixed data_values[]));
void CDFLIST_free_ARRAY PROTOARGs((struct VAR_struct *select, long int num_select));
CDFstatus CDFLIST_create_new_CDF PROTOARGs((struct CDF_struct *CDF,
					    struct VAR_struct *select,
					    long int num_select,
					    struct CDF_struct *new_CDF));
CDFstatus put_attr_value PROTOARGs((CDFid in_CDF_id, int Z,
				    long int entry_type, long int attr_num,
				    long int entry_num, long int out_entry_num,
				    CDFid out_CDF_id, long int data_type,
				    long int num_elements));
CDFstatus put_pad PROTOARGs((CDFid in_CDF_id, long int in_var_num,
			     CDFid out_CDF_id, long int out_var_num, int Z,
			     long int data_type, long int num_elements,
			     void **pad_value));
double get_dim_value PROTOARGs((CDFid CDF_id, int Z, long var_num,
				long data_type, long indices[]));
CDFstatus CDFLIST_new_CDF_info PROTOARGs((struct CDF_struct *CDF,
					  struct VAR_struct *select,
					  long int num_select,
					  struct CDF_struct *new_CDF));
void list_data_vertical PROTOARGs((struct GLOBAL_struct *screen,
				   struct CDF_struct *CDF,
				   struct VAR_struct *select,
				   long int num_select,
				   union mixed *data_values, FILE *fptr));
void list_data_horizontal PROTOARGs((struct GLOBAL_struct *screen,
				     struct CDF_struct *CDF,
				     struct VAR_struct *select, long int num_select,
				     union mixed *data_values, FILE *fptr));
void CDFLIST_list_data PROTOARGs((struct GLOBAL_struct *screen,
				  struct CDF_struct *CDF, struct VAR_struct *select,
				  long int num_select,
				  union mixed *data_values, FILE *fptr));
void get_list_info PROTOARGs((struct VAR_struct *select, long int num_select,
			      int output, int *num_lines_page, int *squeeze));
void next_indices PROTOARGs((long int x[],long int num_dims,
			     long int dim_sizes[], int *copy_complete));
void CDFLIST_check_monoton PROTOARGs((struct VAR_struct *select,
				      struct VAR_struct *variables));
void CDFLIST_check_filters PROTOARGs((struct VAR_struct *select, long int num_select,
				      struct VAR_struct  *variables,
				      long int num_vars, int *mult_flag));
CDFstatus CDFLIST_add_independent PROTOARGs((struct VAR_struct *select,
					     long int *num_select,
					     struct VAR_struct *variables,
					     long int num_vars));
void CDFLIST_select_VAR PROTOARGs((struct GLOBAL_struct *screen,
				   struct CDF_struct *CDF,
				   int num_rows, int num_cols,
				   struct vid_struct display[],
				   struct VAR_struct **select,
				   long int *num_select, int *filters,
				   int *in_field_num));
Logical is_blank PROTOARGs((char *str));
void get_field PROTOARGs((char row_data[], int col, int max_len,
			  char value[], int *first_blank, int *value_entered));
void next_field PROTOARGs((int *col_field, int *select_num, int *start_page,
			   int *row, int *scroll, long int num_poss));
int check_var PROTOARGs((struct vid_struct display[], char var[],
			 long int num_poss));
void CDFLIST_CDFname_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_help_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_menu_keydef PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_special_keydef PROTOARGs((struct   GLOBAL_struct *screen));
void CDFLIST_selectvar_keydef PROTOARGs((struct GLOBAL_struct *screen,
					 int col_field));
void CDFLIST_load_discrete PROTOARGs((char values[], long int num_values,
				      int col_field,
				      struct vid_struct *DIS_display,
				      int *num_rows, int *paste_col));
int CDFLIST_read_VAR PROTOARGs((struct vid_struct  display[],
				struct VAR_struct *possible, long int num_vars,
				long int num_poss, struct VAR_struct **select,
				long int *num_select, int filters[]));
int CDFLIST_filter PROTOARGs((struct VAR_struct  *select, long int num_select,
			      union mixed data_values[], int output));
CDFstatus CDFLIST_write_multidim_to_CDF PROTOARGs((struct CDF_struct *new_CDF, 
						   struct VAR_struct *select,
						   long record_num));
CDFstatus write_multidim_to_CDF PROTOARGs((struct CDF_struct *new_CDF,
					   struct VAR_struct *VN, long record_num));
CDFstatus put_CDF PROTOARGs((struct CDF_struct *new_CDF, long cnt,
			     long int record_num, long int *indices,
			     struct VAR_struct *VN, union  mixed *data_values));
CDFstatus CDFLIST_put_CDF PROTOARGs((struct CDF_struct *new_CDF, long cnt, 
				     long int record_num, long int indices[],
				     struct VAR_struct *select, long int num_select,
				     union  mixed data_values[])); 
CDFstatus CDFLIST_get_discrete PROTOARGs((CDFid CDF_id, int Z, int dim_num,
					  long int var_id, long int data_type,
					  long int num_values,
					  double bin_values[],
					  char *char_values));
void CDFLIST_output PROTOARGs((struct GLOBAL_struct *screen,
			       struct CDF_struct *CDF, FILE **out_file,
			       int *field_num));
void CDFLIST_default_name PROTOARGs((char string[], char default_name[]));
void CDFLIST_clear_row PROTOARGs((WINDOWid vid,struct vid_struct display[],
				  int start_elem, int end_elem, int end_col));
void CDFLIST_file_header PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *select,
				    long int num_select, FILE *fptr));
void CDFLIST_help PROTOARGs((struct GLOBAL_struct  *screen));
int lastc PROTOARGs((char *buf));
void CDFLIST_field_menu PROTOARGs((struct GLOBAL_struct *screen,
				   struct CDF_struct *CDF, int *option));
void CDFLIST_open_screen PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_special_options PROTOARGs((struct GLOBAL_struct *screen,
					CDFid CDF_id, int menu_opt));
void CDFLIST_input_options PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_output_options PROTOARGs((struct GLOBAL_struct *screen));
void CDFLIST_listing_options PROTOARGs((struct GLOBAL_struct *screen,
					CDFid CDF_id));
int CDFLIST_special_option_menu PROTOARGs((WINDOWid vid, int *value,
					   int num_rows));
void CDFLIST_disp_opt PROTOARGs((WINDOWid vid, int value, int num_rows));
void CDFLIST_select_menu_item PROTOARGs((WINDOWid vid, WINDOWid MES_vid,
					 int *rvalue,
					 struct vid_struct display[],
					 long int num_elements, int num_rows,
					 int num_columns, int row_start,
					 int col_start, int mode,
					 int *termcode));
void CDFLIST_CDF_info PROTOARGs((struct GLOBAL_struct *screen,
				 struct CDF_struct *CDF,
				 struct vid_struct CDF_display[],
				 struct vid_struct OUT_display[]));
void load_vid PROTOARGs((WINDOWid vid, struct vid_struct display[],
			 int start_elem, int num_elements, char label[]));
void load_vars PROTOARGs((WINDOWid vid, struct vid_struct display[],
			  int start_num, long int max_vars, int filters[]));
void load_vid_element PROTOARGs((WINDOWid vid, struct vid_struct display[],
				 int element_num));
void CDFLIST_load_keydef PROTOARGs((WINDOWid vid, char line1[], char line2[]));
void CDFLIST_put_selection PROTOARGs((WINDOWid vid,
				     struct vid_struct display[],
				     int element_num, char selection[],
				     int field_len, int video_type));
void CDFLIST_put_select_row PROTOARGs((WINDOWid vid,
				       struct vid_struct display[],
				       int row, int element_num,
				       char selection[], int field_len,
				       int video_type));
void CDFLIST_put_value PROTOARGs((WINDOWid vid, struct vid_struct  display[],
				  int row, int element_num, double bin_value,
				  int video_type, int mode));
void CDFLIST_put_TIME PROTOARGs((WINDOWid vid, struct vid_struct display[],
				 int row, int element_num, double time,
				 int video_type, int mode));
void CDFLIST_put_message PROTOARGs((WINDOWid vid, char message[], int rbell,
				    int video_type, int pause));
void load_menu PROTOARGs((WINDOWid vid, struct vid_struct  display[],
			  int num_elements, char label[]));
void zero_replace PROTOARGs((char string[]));
void CDFLIST_check_name PROTOARGs((char string[]));
void CDFLIST_left_justify  PROTOARGs((char field[]));
void write_eol PROTOARGs((FILE *fptr));
void CDFLIST_print_header PROTOARGs((WINDOWid vid, int *row,
				     struct VAR_struct *select, long int num_select,
				     int output, FILE *fptr, int first));
void CDFLIST_print_string PROTOARGs((struct VAR_struct *VN, int flag,
				     union mixed *data_values));
void CDFLIST_print_data PROTOARGs((WINDOWid vid, int row, int *col, int output,
				   FILE *fptr));
void compute_retrieval_ranges PROTOARGs((struct CDF_struct *CDF,
					 struct VAR_struct *select));
void CDFLIST_specify_monoton PROTOARGs((struct GLOBAL_struct *screen,
					struct CDF_struct *CDF));
void CDFLIST_var_menus PROTOARGs((struct GLOBAL_struct *screen,
				  struct CDF_struct *CDF, int *var_rows,
				  int *var_columns));
void CDFLIST_var_menus_monoton PROTOARGs((struct GLOBAL_struct *screen,
					  struct CDF_struct *CDF,
					  int *var_rows, int *var_columns));
CDFstatus CDFLIST_select_RZ PROTOARGs((struct GLOBAL_struct *screen,
				       struct CDF_struct *CDF, int *tcode));
void zmode_label PROTOARGs((WINDOWid vid));
void free_discrete PROTOARGs((struct VAR_struct *variables));
void free_vars PROTOARGs((struct VAR_struct *variables));
CDFstatus close_var_files PROTOARGs((struct CDF_struct *CDF));
void CDFLIST_free_vars PROTOARGs((struct CDF_struct *CDF));
CDFstatus CDFLIST_close PROTOARGs((struct CDF_struct *CDF));
void NEG_to_POS PROTOARGs((CDFid CDF_id));
CDFstatus zmode_on PROTOARGs((CDFid CDF_id));
CDFstatus zmode_off PROTOARGs((CDFid CDF_id));
void CDFLIST_close_screen PROTOARGs((void));
double r4_r8 PROTOARGs((float *r4));
void CDFLIST_get_double_attr PROTOARGs((CDFid CDF_id, int Z, long attr_num,
					long var_num, double *scale,
					CDFstatus *rcode));
int get_1char PROTOARGs((WINDOWid vid, char * chr, int line_cnt));
int save_var PROTOARGs((struct VAR_struct *select, char *file_name, int *filters));
int restore_var PROTOARGs((struct GLOBAL_struct *screen,
			   struct vid_struct *display, char *file_name,
			   struct VAR_struct *variables, int *filters,
			   long int num_vars));
void check_vars_CDF PROTOARGs((struct GLOBAL_struct *screen,
			       struct CDF_struct *CDF,
			       struct vid_struct *display,
			       struct vid_struct *temp_display,
			       int *filters, int *temp_filters,
			       long int old_num_vars));
void remove_trail PROTOARGs((char *str));
Logical is_var PROTOARGs((CDFid CDF_id, char *mnemonic, long *data_type,
		      struct group *first));
void get_stuff PROTOARGs((char *temp, char *var_mnemonic, char *min,
			  char *max));
void get_init_data PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *select));
void get_data PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *VN,
			 long int record_num, long int *indices,
			 union mixed *data_values));
void was_record_selected PROTOARGs((struct VAR_struct *select, long **first,
				    long **last));
int find_records PROTOARGs((struct CDF_struct *CDF, struct VAR_struct *VN,
			    union mixed *data_values, long *first_record,
			    long *last_record));
int filter1 PROTOARGs((struct VAR_struct *VN, union mixed *data_values));
double convert_value PROTOARGs((long data_type, union mixed *data_values));
void load_fill PROTOARGs((int flag, int len));
void init_indices PROTOARGs((struct VAR_struct *select));
void init_array PROTOARGs((struct VAR_struct *select));
CDFstatus init_discrete PROTOARGs((struct GLOBAL_struct *screen,
				   struct CDF_struct *CDF,
				   struct VAR_struct *possible, long int num_poss));
void next_var PROTOARGs((struct VAR_struct **VN, struct VAR_struct *select, int *var_num,
			 long int *cnt, int *line_cnt, int  *col));
int keep_goin PROTOARGs((struct GLOBAL_struct *screen, int *output,
			 int line_cnt, char *file_name, int *change_output));
void clear_scalars PROTOARGs((struct VAR_struct *select));
void get_header PROTOARGs((struct VAR_struct *select, long num_select, int squeeze));
void fudge_it PROTOARGs((struct VAR_struct *select, long num_select));
Logical var_output PROTOARGs((struct VAR_struct *select, long num_select));
long get_max_vals PROTOARGs((struct VAR_struct *select, long num_select));
long get_max_bytes PROTOARGs((struct VAR_struct *select, long num_select));
void test_eol PROTOARGs((long output, FILE *fptr, int *line_cnt,
			 int num_lines_page, int *page_break));
void whats_happening PROTOARGs((WINDOWid MES_vid, int output,
				char *file_name));
CDFstatus CDFLIST_list_startup PROTOARGs((struct GLOBAL_struct *screen,
					  struct CDF_struct *CDF,
					  struct VAR_struct *select,
					  long int num_select,
					  int *num_lines_page,
					  union mixed *data_values,
					  FILE *fptr,
					  struct CDF_struct *new_CDF,
					  long *first_record,
					  long *last_record));
int CDFLIST_alloc_ARRAY PROTOARGs((struct VAR_struct *select, long num_select));
int CDFLIST_alloc_OUTARRAY PROTOARGs((struct VAR_struct *select, long num_select));
int alloc_array PROTOARGs((void **ptr, long int num_values,
			   long int data_type));
int new_record PROTOARGs((long *indices, long num_dims));
CDFstatus CDFLIST_list_endup PROTOARGs((struct GLOBAL_struct *screen,
					struct CDF_struct *CDF,
					struct VAR_struct *select,
					long int num_select, int data_found,
					int cont, int change_output,
					int line_cnt, union mixed *data_values,
					struct CDF_struct *new_CDF));
CDFstatus copy_display PROTOARGs((struct GLOBAL_struct *screen,
				  struct CDF_struct *CDF,
				  struct vid_struct **VAR_display,
				  int **filters, long int old_num_vars));
int end_of_page PROTOARGs((struct GLOBAL_struct *screen,
			   struct CDF_struct *CDF, struct VAR_struct *select,
			   long int num_select, int *line_cnt, FILE *fptr,
			   int *change_output));
void OffsetIndices PROTOARGs((long offset, long max_values, Logical rowMajor,
			      long numDims, long *nPhyDimValues, long *indices,
			      int *copy_complete));
void calcPhysDim PROTOARGs((Logical rowMajor, long numDims, long *dimSizes, 
			    long *PhyDimValues));
#if defined(dos)
void CDFLIST_draw_main_screen PROTOARGs((struct GLOBAL_struct *screen));
int dos_cont PROTOARGs((void));
#endif

long IndicesOffset PROTOARGs((long numDims, long *dimIndices, long *nPhyDimValues));

#endif
