;------------------------------------------------------------------------------
;
;  NSSDC/CDF				      IDL/CDF Interface, parseEPOCH1.
;
;  Version 1.0, 9-Sep-96, Hughes STX.
;
;  Modification history:
;
;   V1.0   9-Sep-96, J Love	Original version.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; parseEPOCH1.
;------------------------------------------------------------------------------

;+
; NAME:
;       parseEPOCH1
;
; PURPOSE:
;       `parseEPOCH1' is used to parse a CDF_EPOCH value from the alternate/1
;       EPOCH character string.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       epoch = parseEPOCH1 (epString)
;
; INPUTS:
;       epString:       STRING.  The alternate/1 EPOCH character string.  The
;                       syntax of this string is `yyyymmdd.ttttttt' where
;                       `yyyy' is the year, `mm' is the month (1-12), `dd' is
;                       the day of the month (1-31), and `ttttttt' is the
;                       fraction of the day (eg. 5000000 is 12 o'clock noon).
;
;       All input variables must have been created/initialized before calling
;       `parseEPOCH1'.
;
; OUTPUTS:
;       epoch:          DOUBLE (double precision floating-point).  The
;                       parsed CDF_EPOCH value.
;
;       All output variables are (re)created/assigned by `parseEPOCH1'.
;
; EXAMPLE:
;       IDL> epString = '19960909.4829023'
;       IDL> epoch = parseEPOCH1 (epString)
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;        9-Sep-96       Original version.
;-

function parseEPOCH1, epString
on_error, 1
idl_parsepoch1, epString, epoch
return, epoch
end
