;------------------------------------------------------------------------------
;
;  NSSDC/CDF					    IDL/CDF Interface, CDFlib.
;
;  Version 1.4, 21-Aug-96, Hughes STX.
;
;  Modification history:
;
;   V1.0  21-Sep-92, H Leckner	Original version.
;   V1.1  10-Dec-92, H Leckner	Removed print/help debug statements.
;   V1.2  24-Jan-94, J Love	CDF V2.4 (`idl_cdf.pro' split into separate
;                               files as required for online help in IDL).
;   V1.3   1-Nov-94, J Love	CDF V2.5.
;   V1.3a 26-Jun-95, J Love	IDL 4.0.
;   V1.4  21-Aug-96, J Love	CDF V2.6.
;
;------------------------------------------------------------------------------

;------------------------------------------------------------------------------
; CDFlib.
;    Because of how IDL dynamically maps to the CDF library, the current CDF
; and current status code must be specified in each call to CDFlib (if they
; are being used).  To enforce this, the current CDF and current status code
; are set to reserved values before the caller's operations are performed.
;------------------------------------------------------------------------------

;+
; NAME:
;       CDFlib
;
; PURPOSE:
;       `CDFlib' is used to perform all supported CDF operations.  It uses
;       a variable-length argument list to perform one or more operations.
;       The CDF C Reference Manual provides a complete description of how
;       to use `CDFlib'.
;
;       This function is part of the CDF interface provided with the CDF
;       distribution.  IDL also provides its own built-in interface to CDFs.
;
; CALLING SEQUENCE:
;       status = CDFlib (op1, ...)
;
; INPUTS:
;       op1:            LONG.  First operation to be performed.
;
;       All input variables must have been created/initialized before calling
;       `CDFlib'.
;
; OUTPUTS:
;       status:         LONG.  A completion status code.  CDF_OK indicates
;                       success.  The possible status codes are defined by
;                       `cdf0x.pro'.
;
;       All output variables are (re)created/assigned by `CDFlib'.
;
; EXAMPLE:
;       IDL> @cdf0x.pro
;       IDL> status = CDFlib (CDFiif.OPEN_, CDFiix.CDF_, 'rain2', id, $
;       IDL>                  CDFiif.GET_, CDFiix.CDF_FORMAT_, format, $
;       IDL>                  CDFiif.NULL_)
;       IDL> if (status lt CDFx.CDF_WARN) print, 'CDFlib failed.'
;
;       The values of `CDFiif.OPEN_', `CDFiix.CDF_', etc. are defined by
;       `cdf0x.pro'.
;
; RESTRICTIONS:
;       None.
;
; REVISION HISTORY:
;       13-May-93       Original version.
;        1-Nov-94       CDF V2.5.
;       26-Jun-95       IDL 4.0.
;       21-Aug-96       CDF V2.6.
;-

function CDFlib, arg01,arg02,arg03,arg04,arg05,arg06,arg07,arg08,arg09,arg10, $
		 arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18,arg19,arg20, $
		 arg21,arg22,arg23,arg24,arg25,arg26,arg27,arg28,arg29,arg30, $
		 arg31,arg32,arg33,arg34,arg35,arg36,arg37,arg38,arg39,arg40, $
		 arg41,arg42,arg43,arg44,arg45,arg46,arg47,arg48,arg49,arg50, $
		 arg51,arg52,arg53,arg54,arg55,arg56,arg57,arg58,arg59,arg60
common cdfcurrent_, cdfid_, cdfstatus_
on_error, 1
idl_cdflib,cdfid_,cdfstatus_,status, $
	   arg01,arg02,arg03,arg04,arg05,arg06,arg07,arg08,arg09, $
	   arg10,arg11,arg12,arg13,arg14,arg15,arg16,arg17,arg18, $
	   arg19,arg20,arg21,arg22,arg23,arg24,arg25,arg26,arg27, $
	   arg28,arg29,arg30,arg31,arg32,arg33,arg34,arg35,arg36, $
	   arg37,arg38,arg39,arg40,arg41,arg42,arg43,arg44,arg45, $
	   arg46,arg47,arg48,arg49,arg50,arg51,arg52,arg53,arg54, $
	   arg55,arg56,arg57,arg58,arg59,arg60
return, status
end
