;------------------------------------------------------------------------------
;
;  NSSDC/CDF                                             IDL test function.
;
;  Version 1.1, 9-Nov-94, Hughes STX.
;
;  Modification history:
;
;   V1.0   4-Jan-93, H Leckner	Original version.
;   V1.1   9-Nov-94, J Love	CDF V2.5.
;
;------------------------------------------------------------------------------
;
; This function will load all data for a specified rVariable from a CDF into
; an IDL variable.  All of the IDL/CDF interface routines may be entered at
; the IDL command line but for demonstration purposes they will be used in
; an IDL function.
;
; Argument descriptions:                            data type
; CDF_name      input CDF name                      string
; var_name      variable name in CDF                string
; data          array to be returned to IDL         (see creation below)
;
; Executing
; status = get_var('SAMPLE_CDF','VARNAME',data)
;
function get_var, CDF_name, var_name, data
;
; include all CDF definitions
;
@cdf
;
; Open the CDF, note that CDF_id will be returned as the proper data type
;
status = CDFopen(CDF_name,CDF_id)
;
; check the status of the open, if a error is detected print a error and
; return
;
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
;
; Inquire about the structure of the CDF
;
status = CDFinquire(CDF_id,num_dims,dim_sizes,encoding,majority,$ 
                    max_record_num,num_vars,num_attrs)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
;
; Get the number in the CDF of the variable
;
var_num = CDFvarNum(CDF_id, var_name)
if(var_num lt CDF_WARN)then begin
   status = CDFerror(var_num, error_mes)
   print,error_mes
   return,status
endif
;
; Inquire about the variable 
;
status = CDFvarInquire(CDF_id, var_num, out_var_name, data_type, $
                       num_bytes, record_variance, dim_variances)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
;
; We will retrieve some of the metadata from this variable.
; FIELDNAM is a CDF standard attribute and is a description of the variable.
;
attr_num = CDFattrNum(CDF_id, "FIELDNAM")
if(attr_num lt CDF_WARN)then begin
   status = CDFerror(attr_num, error_mes)
   print,error_mes
   return,status
endif
status = CDFattrInquire(CDF_id, attr_num, out_attr_name, $
                        attr_scope, max_entry)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
;
; Need the data type and size of this attribute
;
status = CDFattrEntryInquire(CDF_id, attr_num, var_num, $
                             attr_data_type, num_elements)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
status = CDFattrGet(CDF_id, attr_num, var_num, attr_value)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
print,'Loading variable ',var_name,': ',attr_value
;
; We will now get ready to load all data for this variable, 
; use the CDF structure to initialize all parameters to perform this
; operation
;
recStart = 0l
recCount = max_record_num+1
recInterval=1l
indices = lonarr(num_dims)
counts = lonarr(num_dims)
intervals = lonarr(num_dims)
for dim_num=0, num_dims-1 do begin
    indices(dim_num) = 0;
    counts(dim_num) = dim_sizes(dim_num)
    intervals(dim_num) = 1
endfor
status = CDFvarHyperGet(CDF_id,var_num, recStart,recCount,recInterval, $
                        indices,counts,intervals,inbuf)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
;
; IDL needs to have the CDF in column majority in order to plot properly,
; we will supply a routine that will convert from ROW to COLUMN major.
; Converting character data is not supported in this release
;
if((majority eq ROW_MAJOR) and $
   (data_type ne CDF_CHAR and data_type ne CDF_UCHAR))then begin
   print,'Converting from ROW to COLUMN major'
;
; Need to know the number of bytes of this data type (e.g. 1,2,4,8)
;
   nbytes,data_type,num_bytes_dt
;
; Now convert
;
   status = row_to_col (inbuf, data, num_dims, dim_sizes, num_bytes_dt, $
                        recCount)
endif else begin
;
; No conversion necessary, load input buffer into return data buffer
;
   data = inbuf
endelse
status=CDFclose(CDF_id)
if(status lt CDF_WARN)then begin
   st = CDFerror(status, error_mes)
   print,error_mes
   return,status
endif
return,CDF_OK
end

pro nbytes,data_type,num_bytes
@cdf
num_bytes = 0l
Case 1 of
 (data_type eq CDF_INT1)   : num_bytes = 1l
 (data_type eq CDF_INT2)   : num_bytes = 2l
 (data_type eq CDF_INT4)   : num_bytes = 4l
 (data_type eq CDF_UINT1)  : num_bytes = 1l
 (data_type eq CDF_UINT2)  : num_bytes = 2l
 (data_type eq CDF_UINT4)  : num_bytes = 4l
 (data_type eq CDF_REAL4)  : num_bytes = 4l
 (data_type eq CDF_REAL8)  : num_bytes = 8l
 (data_type eq CDF_EPOCH)  : num_bytes = 8l
 (data_type eq CDF_BYTE)   : num_bytes = 1l
 (data_type eq CDF_FLOAT)  : num_bytes = 4l
 (data_type eq CDF_DOUBLE) : num_bytes = 8l
 (data_type eq CDF_CHAR)   : num_bytes = 1l
 (data_type eq CDF_UCHAR)  : num_bytes = 1l
endcase
return
end
