/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.3 $";
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/dfutilF.c,v 1.3 1991/10/22 17:56:10 dilg beta $

$Log: dfutilF.c,v $
 * Revision 1.3  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 1.2  1990/07/23  08:00:30  mfolk
 * Took out: #include "/soft/hdf/include/dfsd.h".  (Mike Folk)
 *
 * Revision 1.1  90/06/06  00:30:57  mfolk
 * Initial revision
 * 
*/
/*-----------------------------------------------------------------------------
 * File:    dfutilF.c
 * Purpose: C stubs for Fortran utility routines
 * Invokes: dfutil.c
 * Contents: 
 *  dfindnr_:       For a given tag, find the next ref after the given ref
 *---------------------------------------------------------------------------*/

#include "df.h"

#ifdef IBM6000
#   define dfindnr_             dfindnr
#   define dffindnextref_       dffindnextref
#endif /* IBM6000 */

#ifdef DF_CAPFNAMES
#   define dfindnr_	        DFINDNR 
#   define dffindnextref_	DFFINDNEXTREF
#endif /* DF_CAPFNAMES */

/*-----------------------------------------------------------------------------
 * Name:    dfindnr
 * Purpose: For this tag, find the ref after lref
 * Inputs:  dfile: ptr to open DF file
 *          tag:   tag to look for
 *          lref:  ref after which to search
 *
 * Returns: the desired ref if successful, on failure with	DFerror set
 * Users:   HDF Fortran programmers
 * Invokes: DFfindnextref
 *---------------------------------------------------------------------------*/

    FCALLKEYW int32
#if defined __STDC__ || defined PC
dfindnr_(int *dfile, int *tag, int *lref)
#else
dfindnr_(dfile, tag, lref)
     int *dfile, 
         *tag, 
         *lref;
#endif /* __STDC__ || PC */
{
    return(DFfindnextref(*dfile, (uint16) *tag, (uint16) *lref));
}

/*
CEND7MAX
*/

/*-----------------------------------------------------------------------------
 * Name:    dffindnextref
 * Purpose: For this tag, find the ref after lref
 * Inputs:  dfile: ptr to open DF file
 *          tag:   tag to look for
 *          lref:  ref after which to search
 *
 * Returns: the desired ref if successful, on failure with	DFerror set
 * Users:   HDF Fortran programmers
 * Invokes: DFfindnextref
 *---------------------------------------------------------------------------*/

    FCALLKEYW int32
#if defined __STDC__ || defined PC
dffindnextref_(int *dfile, int *tag, int *lref)
#else
dffindnextref_(dfile, tag, lref)
     int *dfile, 
         *tag, 
         *lref;
#endif /* __STDC__ || PC */
{
    return(DFfindnextref(*dfile, (uint16) *tag, (uint16) *lref));
}
