/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 3.8 $"
#endif
/*
$Header: /pita/work/HDF/dev/RCS/src/dfr8F.c,v 3.8 1991/10/22 17:56:10 dilg beta $
$Log: dfr8F.c,v $
 * Revision 3.8  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.7  1990/07/06  09:39:18  clow
 * Added fortran stubs for DFR8readref:  d8rref, d8readref, and d8irref_
 *
 * Revision 3.6  90/06/29  10:30:00  clow
 * Fixed bug in digimg_ by dereferencing the xdim ydim pointers
 * 
 * Revision 3.5  90/05/17  17:47:22  clow
 * fix bug with the position of include
 * 
 * Revision 3.4  90/05/17  15:59:25  clow
 * make the mac ls_fortran to C call *NOT* have to go through an additional
 * Fortran stub (for %ref()), so we can remove the different function names
 * for the MAC
 * 
 * Revision 3.3  90/05/14  23:09:42  clow
 * "beautify" function declaration with MACROs
 * 
*/
/*-----------------------------------------------------------------------------
 * File:    dfr8F.c
 * Purpose: C stubs for Fortran RIS routines
 * Invokes: dfr8.c dfkit.c
 * Contents: 
 *  d8spal_:    Set palette to write out with subsequent images
 *  d8first_:   Call DFR8restart to reset sequencing to first image
 *  d8igdim_:   Call DFR8getdims to get dimensions of next image
 *  d8igimg_:   Call DFR8getimage to get next image
 *  d8ipimg_:   Call DFR8putimage to write image to new file
 *  d8iaimg_:   Call DFR8putimage to add image to existing file
 *  d8irref_:   Call DFR8readref to set ref to get next
 *  dfr8setpalette_:Set palette to write out with subsequent images
 *  dfr8restart_:Call DFR8restart to reset sequencing to first image
 * Remarks: none
 *---------------------------------------------------------------------------*/

#include "dfr8.h"

#ifdef IBM6000
#   define d8spal_      d8spal
#   define d8first_     d8first
#   define d8igdim_     d8igdim
#   define d8igimg_     d8igimg
#   define d8ipimg_     d8ipimg
#   define d8iaimg_     d8iaimg
#   define d8irref_     d8irref
#   define dfr8setpalette_      dfr8setpallette
#   define dfr8restart_ dfr8restart
#endif /* IBM6000 */

#ifdef DF_CAPFNAMES
#   define d8spal_	D8SPAL
#   define d8first_	D8FIRST
#   define d8igdim_	D8IGDIM
#   define d8igimg_	D8IGIMG
#   define d8ipimg_	D8IPIMG
#   define d8iaimg_	D8IAIMG
#   define d8irref_	D8IRREF
#   define dfr8setpalette_	DFR8SETPALETTE
#   define dfr8restart_	DFR8RESTART
#endif /* DF_CAPFNAMES */


/*-----------------------------------------------------------------------------
 * Name:    d8spal_
 * Purpose: Set palette to be written out with subsequent images
 * Inputs:  pal: palette to associate with subsequent images
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8setpalette
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8spal_(_fcd pal)
#else
d8spal_(pal)
    _fcd pal;
#endif /* __STDC__ || PC */
{
    return (DFR8setpalette((uint8 *)_fcdtocp(pal)));
}


/*-----------------------------------------------------------------------------
 * Name:    d8first_
 * Purpose: Reset sequencing back to first image
 * Inputs:  none
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8restart
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8first_(void)
#else
d8first_()
#endif /* __STDC__ || PC */
{
    return(DFR8restart());
}


/*-----------------------------------------------------------------------------
 * Name:    d8igdim_
 * Purpose: Get dimensions of next image using DFR8getdims
 * Inputs:  filename: name of HDF file
 *          xdim, ydim - integers to return dimensions in
 *          ispal - boolean to indicate whether the image includes a palette
 *          lenfn - length of filename
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8getdims
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8igdim_(_fcd filename, int *xdim, int *ydim, int *ispal, int *lenfn)
#else
d8igdim_(filename, xdim, ydim, ispal, lenfn)
    _fcd filename;
    int *xdim, *ydim, *ispal, *lenfn;
#endif /* __STDC__ || PC */
{
    char *fn;
    int ret;

    fn = (char *)DFIf2cstring(filename, *lenfn);
    ret =  DFR8getdims(fn, (int32*)xdim, (int32*)ydim, ispal);
    (void) DFIfreespace(fn);
    return(ret);
}


/*-----------------------------------------------------------------------------
 * Name:    d8igimg_
 * Purpose: Get next image using DFR8getimage
 * Inputs:  filename: name of HDF file
 *          image: space provided for returning image
 *          xdim, ydim: dimension of space provided for image
 *          pal: space of 768 bytes for palette
 *          lenfn: length of filename
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8getimage
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8igimg_(_fcd filename, _fcd image, int *xdim, int *ydim, _fcd pal, int *lenfn)
#else
d8igimg_(filename, image, xdim, ydim, pal, lenfn)
    _fcd filename, image, pal;
    int *xdim, *ydim, *lenfn;
#endif /* __STDC__ || PC */
{
    char *fn;
    int ret;

    fn = (char *)DFIf2cstring(filename, *lenfn);
    ret =  DFR8getimage(fn, (uint8 *)_fcdtocp(image),
			(int32)*xdim, (int32)*ydim, (uint8 *)_fcdtocp(pal));
    (void) DFIfreespace(fn);
    return(ret);
}


/*-----------------------------------------------------------------------------
 * Name:    d8ipimg_
 * Purpose: Write out image to new file
 * Inputs:  filename: name of HDF file
 *          image: image to write out
 *          xdim, ydim: dimensions of image to write out
 *          compress: compression scheme
 *          lenfn: length of filename
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8putimage
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8ipimg_(_fcd filename, _fcd image, int *xdim, int *ydim, int *compress,
	 int *lenfn)
#else
d8ipimg_(filename, image, xdim, ydim, compress, lenfn)
    _fcd filename, image;
    int *xdim, *ydim, *compress, *lenfn;
#endif /* __STDC__ || PC */
{
    char *fn;
    int ret;

    fn = (char *)DFIf2cstring(filename, *lenfn);
    ret = DFR8putimage(fn, (uint8 *)_fcdtocp(image),
		       (int32)*xdim, (int32)*ydim, *compress);
    (void) DFIfreespace(fn);
    return(ret);
}


/*-----------------------------------------------------------------------------
 * Name:    d8iaimg_
 * Purpose: Add image to existing file
 * Inputs:  filename: name of HDF file
 *          image: image to write out
 *          xdim, ydim: dimensions of image to write out
 *          compress: compression scheme
 *          lenfn: length of filename
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8addimage
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8iaimg_(_fcd filename, _fcd image, int *xdim, int *ydim, int *compress,
	 int *lenfn)
#else
d8iaimg_(filename, image, xdim, ydim, compress, lenfn)
    _fcd filename, image;
    int *xdim, *ydim, *compress, *lenfn;
#endif /* __STDC__ || PC */
{
    char *fn;
    int ret;

    fn = (char *)DFIf2cstring(filename, *lenfn);
    ret = DFR8addimage(fn, (uint8 *)_fcdtocp(image),
		       (int32)*xdim, (int32)*ydim, *compress);
    (void) DFIfreespace(fn);
    return(ret);
}

/*-----------------------------------------------------------------------------
 * Name:    DFR8readref
 * Purpose: Set ref of image to get next
 * Inputs:  filename: file to which this applies
 *          ref: reference number of next get
 * Returns: 0 on success, -1 on failure
 * Users:   HDF programmers, other routines and utilities
 * Invokes: DFR8Iopen, DFIfind
 * Remarks: checks if image with this ref exists
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
d8irref_(_fcd filename, int *ref, int *fnlen)
#else
d8irref_(filename, ref, fnlen)
    _fcd filename;
    int *ref, *fnlen;
#endif /* __STDC__ || PC */
{
    char *fn;
    int ret;

    fn = (char *)DFIf2cstring(filename, *fnlen);
    if (!fn) return -1;
    ret = DFR8readref(fn, (uint16)*ref);
    DFIfreespace(fn);
    return ret;
}


/*-----------------------------------------------------------------------------
 * Name:    dfr8setpalette_
 * Purpose: Set palette to be written out with subsequent images
 * Inputs:  pal: palette to associate with subsequent images
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8setpalette
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
dfr8setpalette_(_fcd pal)
#else
dfr8setpalette_(pal)
    _fcd pal;
#endif /* __STDC__ || PC */
{

    return (DFR8setpalette((uint8 *)_fcdtocp(pal)));
}

/*-----------------------------------------------------------------------------
 * Name:    dfr8restart_
 * Purpose: Reset sequencing back to first image
 * Inputs:  none
 * Returns: 0 on success, -1 on failure with DFerror set
 * Users:   Fortran stub routine
 * Invokes: DFR8restart
 *---------------------------------------------------------------------------*/

	FCALLKEYW int
#if defined __STDC__ || defined PC
dfr8restart_(void)
#else
dfr8restart_()
#endif /* __STDC__ || PC */
{

    return(DFR8restart());
}
