/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfr8.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfr8.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFR8 /* avoid re-inclusion */

#define DFR8
#include "df.h"

/* description record: used to describe image data, palette data etc. */
typedef struct {
    int32 xdim, ydim;		/* dimensions of data */
    DFdi nt;			/* number type of data */
    int16 ncomponents, interlace; /* data ordering: chunky / planar etc */
    DFdi compr;			/* compression */
    /* ### Note: compression is currently uniquely described with a tag.
       No data is attached to this tag/ref.  But this capability is
       provided for future expansion, when this tag/ref might point to
       some data needed for decompression, such as the actual encodings */
} DFRdr;

/* structure to hold RIG info */
typedef struct DFRrig {
    DFdi image;			/* image */
    DFRdr descimage;		/* image data description */
    DFdi lut;			/* color look-up table (palette) */
    DFRdr desclut;		/* look-up table description */
    DFdi mattechannel;
    DFRdr descmattechannel;
    int32 xpos, ypos;		/* X-Y position of image on screen */
    float aspectratio;		/* ratio of pixel height to width */
    float ccngamma, ccnred[3], ccngrren[3], ccnblue[3], ccnwhite[3];
				/* color correction parameters */
    char *cf;			/* color format */
} DFRrig;

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/*  prototypes for dfr8.c */

extern int DFR8getdims(char huge *filename, int32 huge *pxdim,
                       int32 huge *pydim, int huge *pispal);
extern int DFR8getimage(char huge *filename, uint8 huge *image, int32 xdim,
                        int32 ydim, uint8 huge *pal);
extern int DFR8setpalette(uint8 huge *pal);
extern int DFR8Iputimage(char huge *filename, uint8 huge *image, int32 xdim,
                         int32 ydim, unsigned int compress, int op);
extern int DFR8putimage(char huge *filename, uint8 huge *image, int32 xdim,
                        int32 ydim, int compress);
extern int DFR8addimage(char huge *filename, uint8 huge *image, int32 xdim,
                        int32 ydim, int compress);
extern int DFR8getrig(DF huge *dfile, uint16 ref, DFRrig huge *rig);
extern int DFR8putrig(DF huge *dfile, uint16 ref, DFRrig huge *rig, int wdim);
extern int DFR8nimages(char huge *filename);
extern int DFR8readref(char huge *filename, uint16 ref);
extern int DFR8writeref(char huge *filename, uint16 ref);
extern int DFR8restart(void);
extern int DFR8lastref(void);
extern DF huge *DFR8Iopen(char huge *filename, int access);
extern int DFR8Iriginfo(DF huge *dfile);


/* prototypes for dfr8F.c */

extern int d8spal_(char huge *pal);
extern int d8first_(void);
extern int d8igdim_(char huge *filename, int huge *xdim, int huge *ydim,
                    int huge *ispal, int huge *lenfn);
extern int d8igimg_(char huge *filename, char huge *image, int huge *xdim,
                    int huge *ydim, char huge *pal, int huge *lenfn);
extern int d8ipimg_(char huge *filename, char huge *image, int huge *xdim,
                    int huge *ydim, int huge *compress, int huge *lenfn);
extern int d8iaimg_(char huge *filename, char huge *image, int huge *xdim,
                    int huge *ydim, int huge *compress, int huge *lenfn);
extern int d8irref_(char huge *filename, int huge *ref, int huge *fnlen);
extern int dfr8setpalette_(char huge *pal);
extern int dfr8restart_(void);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfr8.c */

extern int DFR8getdims(char *filename, int32 *pxdim, int32 *pydim, int *pispal);
extern int DFR8getimage(char *filename, uint8 *image, int32 xdim, int32 ydim,
                        uint8 *pal);
extern int DFR8setpalette(uint8 *pal);
extern int DFR8Iputimage(char *filename, uint8 *image, int32 xdim, int32 ydim,
                         uint16 compress, int op);
extern int DFR8putimage(char *filename, uint8 *image, int32 xdim, int32 ydim,
                        int compress);
extern int DFR8addimage(char *filename, uint8 *image, int32 xdim, int32 ydim,
                        int compress);
extern int DFR8getrig(DF *dfile, uint16 ref, DFRrig *rig);
extern int DFR8putrig(DF *dfile, uint16 ref, DFRrig *rig, int wdim);
extern int DFR8nimages(char *filename);
extern int DFR8readref(char *filename, uint16 ref);
extern int DFR8writeref(char *filename, uint16 ref);
extern int DFR8restart(void);
extern int DFR8lastref(void);
extern DF *DFR8Iopen(char *filename, int access);
extern int DFR8Iriginfo(DF *dfile);


/* prototypes for dfr8F.c */

extern int d8spal_(char *pal);
extern int d8first_(void);
extern int d8igdim_(char *filename, int *xdim, int *ydim, int *ispal,
                    int *lenfn);
extern int d8igimg_(char *filename, char *image, int *xdim, int *ydim,
                    char *pal, int *lenfn);
extern int d8ipimg_(char *filename, char *image, int *xdim, int *ydim,
                    int *compress, int *lenfn);
extern int d8iaimg_(char *filename, char *image, int *xdim, int *ydim,
                    int *compress, int *lenfn);
extern int d8irref_(char *filename, int *ref, int *fnlen);
extern int dfr8setpalette_(char *pal);
extern int dfr8restart_(void);


#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

extern int DFR8getdims();
extern int DFR8getimage();
extern int DFR8setpalette();
extern int DFR8Iputimage();
extern int DFR8putimage();
extern int DFR8addimage();
extern int DFR8getrig();
extern int DFR8putrig();
extern int DFR8nimages();
extern int DFR8readref();
extern int DFR8writeref();
extern int DFR8restart();
extern int DFR8lastref();
extern DF *DFR8Iopen();
extern int DFR8Iriginfo();


/* prototypes for dfr8F.c */

extern int d8spal_();
extern int d8first_();
extern int d8igdim_();
extern int d8igimg_();
extern int d8ipimg_();
extern int d8iaimg_();
extern int d8irref_();
extern int dfr8setpalette_();
extern int dfr8restart_();


#endif /* __STDC__ */

#endif /* DFR8 */

