/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfcomp.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: dfcomp.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DFCOMP /* avoid re-inclusion */

#define DFCOMP
#include "df.h"

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfcomp.c */

extern int32 DFputcomp(DF huge *dfile, uint16 tag, uint16 ref,
		       uint8 huge *image, int32 xdim, int32 ydim,
		       uint8 huge *palette, uint8 huge *newpal, int16 scheme);
extern int DFgetcomp(DF huge *dfile, uint16 tag, uint16 ref, uint8 huge *image,
		     int32 xdim, int32 ydim, uint16 scheme);
extern int DFCrle(uint8 huge *buf, uint8 huge *bufto, int32 len);
extern int DFCunrle(uint8 huge *buf, uint8 huge *bufto, int32 outlen,
		    int resetsave);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfcomp.c */

extern int32 DFputcomp(DF *dfile, uint16 tag, uint16 ref, uint8 *image,
		       int32 xdim, int32 ydim, uint8 *palette, uint8 *newpal,
		       int16 scheme);
extern int DFgetcomp(DF *dfile, uint16 tag, uint16 ref, uint8 *image, int32 xdim,
		     int32 ydim, uint16 scheme);
extern int DFCrle(uint8 *buf, uint8 *bufto, int32 len);
extern int DFCunrle(uint8 *buf, uint8 *bufto, int32 outlen, int resetsave);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfcomp.c */

extern int32 DFputcomp();
extern int DFgetcomp();
extern int DFCrle();
extern int DFCunrle();

#endif /* __STDC__ */

#endif /* DFCOMP */
