/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/df24.h,v 1.1 1991/10/22 17:56:10 dilg beta $

$Log: df24.h,v $
 * Revision 1.1  1991/10/22  17:56:10  dilg
 * Initial revision
 *
*/
#ifndef DF24 /* avoid re-inclusion */

#define DF24

#include "df.h"

/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/*  prototypes for df24.c  */

extern int DF24getdims(char huge *filename, int32 huge *pxdim,
		       int32 huge *pydim, int huge *pil);
extern int DF24reqil(int il);
extern int DF24getimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DF24setdims(int32 xdim, int32 ydim);
extern int DF24setil(int il);
extern int DF24restart(void);
extern int DF24addimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DF24putimage(char huge *filename, uint8 huge *image, int32 xdim,
			int32 ydim);
extern int DF24readref(char huge *filename, uint16 ref);

/*  prototypes for df24F.c  */

extern int d2reqil_(int huge *il);
extern int d2sdims_(int32 huge *xdim, int32 huge *ydim);
extern int d2igdim_(char huge *filename, int32 huge *pxdim, int32 huge *pydim,
                    int huge *pil, int huge *fnlen);
extern int d2igimg_(char huge *filename, char huge *image, int32 huge *xdim,
                    int32 huge *ydim, int huge *fnlen);
extern int d2iaimg_(char huge *filename, char huge *image, int32 huge *xdim,
                    int32 huge *ydim, int huge *fnlen, int huge *newfile);
extern int d2setil_(int huge *il);
extern int d2first_(void);
extern int df24reqil_(int huge *il);
extern int df24setdims_(int32 huge *xdim, int32 huge *ydim);
extern int df24setil_(int huge *il);
extern int df24restart_(void);
extern int d2irref_(char huge *filename, int huge *ref, int huge *fnlen);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/*  prototypes for df24.c  */

extern int DF24getdims(char *filename, int32 *pxdim, int32 *pydim, int *pil);
extern int DF24reqil(int il);
extern int DF24getimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DF24setdims(int32 xdim, int32 ydim);
extern int DF24setil(int il);
extern int DF24restart(void);
extern int DF24addimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DF24putimage(char *filename, uint8 *image, int32 xdim, int32 ydim);
extern int DF24readref(char *filename, uint16 ref);

/*  prototypes for df24F.c  */

extern int d2reqil_(int *il);
extern int d2sdims_(int32 *xdim, int32 *ydim);
extern int d2igdim_(char *filename, int32 *pxdim, int32 *pydim, int *pil,
                    int *fnlen);
extern int d2igimg_(char *filename, char *image, int32 *xdim, int32 *ydim,
                    int *fnlen);
extern int d2iaimg_(char *filename, char *image, int32 *xdim, int32 *ydim,
                    int *fnlen, int *newfile);
extern int d2setil_(int *il);
extern int d2first_(void);
extern int df24reqil_(int *il);
extern int df24setdims_(int32 *xdim, int32 *ydim);
extern int df24setil_(int *il);
extern int df24restart_(void);
extern int d2irref_(char *filename, int *ref, int *fnlen);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/*  prototypes for df24.c  */

extern int DF24getdims();
extern int DF24reqil();
extern int DF24getimage();
extern int DF24setdims();
extern int DF24setil();
extern int DF24restart();
extern int DF24addimage();
extern int DF24putimage();
extern int DF24readref();

/*  prototypes for df24F.c  */

extern int d2reqil_();
extern int d2sdims_();
extern int d2igdim_();
extern int d2igimg_();
extern int d2iaimg_();
extern int d2setil_();
extern int d2first_();
extern int df24reqil_();
extern int df24setdims_();
extern int df24setil_();
extern int df24restart_();
extern int d2irref_();

#endif /* __STDC__ */

#endif /* DF24 */
