/*
 * This file is part of tela the Tensor Language.
 * Copyright (c) 1994-1995 Pekka Janhunen
 */

#if defined(HPUX) /* Modif Terez 27/02/95  && !defined(__GNUC__)   */
#  define NO_UNDERSCORE_IN_FORTRAN_NAMES
#endif

#ifdef NO_UNDERSCORE_IN_FORTRAN_NAMES
#  define Fortran(x) x
#else
#  define Fortran(x) x##_
#endif

#ifndef UNICOS

#  define VCFFTF Fortran(vcfftf)		// complex transform
#  define VCFFTB Fortran(vcfftb)		// its inverse
#  define VCFFTI Fortran(vcffti)		// initializer of the above routine pair

#  define VRFFTF Fortran(vrfftf)		// real transform
#  define VRFFTB Fortran(vrfftb)		// its inverse
#  define VRFFTI Fortran(vrffti)		// initializer for rfft

#  define VSINT Fortran(vsint)			// sine transform
#  define VSINTI Fortran(vsinti)		// initializer for sint

#  define VCOST Fortran(vcost)			// cosine transform
#  define VCOSTI Fortran(vcosti)		// initializer for cost

#  define VSINQF Fortran(vsinqf)		// quarter-wave sine transform
#  define VSINQB Fortran(vsinqb)		// its inverse
#  define VSINQI Fortran(vsinqi)		// initializer for sinq

#  define VCOSQF Fortran(vcosqf)		// quarter-wave cosine transform
#  define VCOSQB Fortran(vcosqb)		// its inverse
#  define VCOSQI Fortran(vcosqi)		// initializer for cosq

#endif

extern "C" {

// FFTPACK functions
	
extern void VCFFTF(const Tint& N, Tcomplex data[], const Treal wrk[]);
extern void VCFFTB(const Tint& N, Tcomplex data[], const Treal wrk[]);
extern void VCFFTI(const Tint& N, Treal wrk[]);

extern void VRFFTF(const Tint& M, const Tint& N, Treal data[], Treal datawork[], const Treal wrk[]);
extern void VRFFTB(const Tint& N, Treal data[], const Treal wrk[]);
extern void VRFFTI(const Tint& N, Treal wrk[]);

extern void VSINT(const Tint& N, Treal data[], const Treal wrk[]);
extern void VSINTI(const Tint& N, Treal wrk[]);

extern void VCOST(const Tint& N, Treal data[], const Treal wrk[]);
extern void VCOSTI(const Tint& N, Treal wrk[]);

extern void VSINQF(const Tint& N, Treal data[], const Treal wrk[]);
extern void VSINQB(const Tint& N, Treal data[], const Treal wrk[]);
extern void VSINQI(const Tint& N, Treal wrk[]);

extern void VCOSQF(const Tint& N, Treal data[], const Treal wrk[]);
extern void VCOSQB(const Tint& N, Treal data[], const Treal wrk[]);
extern void VCOSQI(const Tint& N, Treal wrk[]);

}

