/*
 * This file is part of tela the Tensor Language.
 * Copyright (c) 1994 Pekka Janhunen
 */

#if defined(HPUX) && !defined(__GNUC__)
#  define NO_UNDERSCORE_IN_FORTRAN_NAMES
#endif

#ifdef NO_UNDERSCORE_IN_FORTRAN_NAMES
#  define Fortran(x) x
#else
#  define Fortran(x) x##_
#endif

#ifndef UNICOS
#  define CFFTI Fortran(cffti)
#  define CFFTF Fortran(cfftf)
#  define CFFTB Fortran(cfftb)
#endif

extern "C" {

// FFTPACK functions
	
extern int CFFTI(const Tint& N, Treal wrk[]);
extern int CFFTF(const Tint& N, Tcomplex data[], const Treal wrk[]);
extern int CFFTB(const Tint& N, Tcomplex data[], const Treal wrk[]);

}

