/*****************************************************************************
* 
*			  NCSA HDF version 3.10r5
*			     October 24, 1991
*
* NCSA HDF Version 3.10r5 source code and documentation are in the public
* domain.  Specifically, we give to the public domain all rights for future
* licensing of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
*****************************************************************************/
/*
$Header: /pita/work/HDF/dev/RCS/src/dfan.h,v 3.1 1991/10/22 17:56:10 dilg beta $

$Log: dfan.h,v $
 * Revision 3.1  1991/10/22  17:56:10  dilg
 * 5
 * HDF3.1r5
 *
 * New machine types added:
 *
 *         PC      - IBM PC (DOS)
 *         WIN     - IBM PC (Microsoft Windows 3.0)
 *         IBM6000 - IBM RS/6000 (AIX)
 *         CONVEX  - Convex C-2 (Unix)
 *
 * Bugs fixed in:
 *
 *         scup32.f
 *         cspck32.f
 *         dfpFf.f
 *         dfpF.c
 *         dfsd.c
 *
 * New utility added:
 *
 *         ristosds.c - convert raster images to sds.
 *
 * Also:
 *         All code for the library was modified to conform to the
 *         ANSI C standard.
 *
 * Revision 3.0  1990/02/02  20:30:34  clow
 * *** empty log message ***
 *
*/
/*------------------------------------------------------------------------------
 * File:    dfan.h
 * Purpose: header file for the Annotations set
 * Invokes: df.h
 * Contents: 
 *  Structure definitions: DFANdirentry, DFANdirhead
 *  Constant definitions: DFAN_LABEL, DFAN_DESC
 * Remarks: none
 *----------------------------------------------------------------------------*/


#ifndef DFAN                        /* avoid re-inclusion */
#define DFAN

#include "df.h"

#define DFAN_LABEL  0
#define DFAN_DESC   1

#define DFAN_DEFENTRIES 16          /* no of dir entries to add at a time */

    /* This structure stores an entry in the label/desc directory */
    /* for a label/desc in the file, it gives the ref of the label/desc,
        and the tag/ref of the data item to which the label/desc relates */

typedef struct {
        uint16 annref;                  /* ref of annotation */
        uint16 datatag, dataref;        /* tag/ref of data */
    } DFANdirentry;

    /* This structure is a head node for the directory, which is organized as
        as a linked list of arrays.  DFANdirentry is the structure of an
        array element, while DFANdirhead is the list element */
typedef struct DFANdirhead {
        int nentries;
        struct DFANdirhead *next;
        DFANdirentry entries[1];        /* actually an arbitrary size array */
    } DFANdirhead;

/* testing...
#ifndef VMS
int32 DFANIgetannlen();
#else
int32 _DFANIgetannlen();
#endif
...tested */


/*----------------------------------------------------------------------------*/
/*                           Function Prototypes                              */

#if defined __STDC__ || defined PC

#ifdef PC

/* prototypes for dfan.c */

extern int32 DFANgetlablen(char huge *filename, uint16 tag, uint16 ref);
extern int DFANgetlabel(char huge *filename, uint16 tag, uint16 ref,
			char huge *label, int32 maxlen);
extern int32 DFANgetdesclen(char huge *filename, uint16 tag, uint16 ref);
extern int DFANgetdesc(char huge *filename, uint16 tag, uint16 ref,
		       char huge *desc, int32 maxlen);
extern int32 DFANgetfidlen(DF huge *dfile, int isfirst);
extern int32 DFANgetfid(DF huge *dfile, char huge *id, int maxlen, int isfirst);
extern int32 DFANgetfdslen(DF huge *dfile, int isfirst);
extern int32 DFANgetfds(DF huge *dfile, char huge *desc, int maxlen,
		       int isfirst);
extern int DFANputlabel(char huge *filename, uint16 tag, uint16 ref,
			char huge *label);
extern int DFANputdesc(char huge *filename, uint16 tag, uint16 ref,
		       char huge *desc, int32 desclen);
extern int DFANaddfid(DF huge *dfile, char huge *id);
extern int DFANaddfds(DF huge *dfile, char huge *desc, int32 desclen);
extern int DFANlastref(void);
extern int DFANlablist(char huge *filename, uint16 tag, uint16 huge *reflist,
		       char huge *labellist, int listsize, int maxlen,
		       int startpos);
extern DF huge *DFANIopen(char huge *filename, int access);
extern int DFANIlocate(DF huge *dfile, int type, uint16 tag, uint16 ref);
extern int DFANIaddentry(int type, uint16 annref, uint16 datatag,
			 uint16 dataref);
extern int32 DFANIgetannlen(char huge *filename, uint16 tag, uint16 ref,
			    int type);
extern int DFANIgetann(char huge *filename, uint16 tag, uint16 ref,
		       char huge *ann, int32 maxlen, int type);
extern int DFANIputann(char huge *filename, uint16 tag, uint16 ref,
		       char huge *ann, int32 annlen, int type);
extern int DFANIlablist(char huge *filename, uint16 tag, uint16 huge *reflist,
			char huge *labellist, int listsize, int maxlen,
			int startpos, int isfortran);
extern int32 DFANIgetfannlen(DF huge *dfile, int type, int isfirst);
extern int32 DFANIgetfann(DF huge *dfile, char huge *ann, int32 maxlen,
			  int type, int isfirst);
extern int DFANIaddfann(DF huge *dfile, char huge *ann, int32 annlen, int type);


/* prototypes for dfanF.c */

extern int32 daiganl_(char huge *filename, int huge *tag, int huge *ref,
		     int huge *type, int huge *fnlen);
extern int32 daigann_(char huge *filename, int huge *tag, int huge *ref,
		     char huge *annotation, int huge *maxlen, int huge *type,
		     int huge *fnlen);
extern int32 daipann_(char huge *filename, int huge *tag, int huge *ref,
		     char huge *annotation, int huge *annlen, int huge *type,
		     int huge *fnlen);
extern int dailist_(char huge *filename, int huge *tag, int huge *reflist,
		    char huge *labellist, int huge *listsize, int huge *maxlen,
		    int huge *startpos, int huge *fnlen);
extern int dalref_(void);
extern int dfanlastref_(void);
extern int32 dfanaddfds_(int huge *dfile, char huge *desc, int huge *desclen);
extern int32 dfangetfidlen_(int huge *dfile, int huge *isfirst);
extern int32 dfangetfdslen_(int huge *dfile, int huge *isfirst);
extern int32 dfangetfid_(int huge *dfile, char huge *id, int huge *maxlen,
			int huge *isfirst);
extern int32 dfangetfds_(int huge *dfile, char huge *id, int huge *maxlen,
			int huge *isfirst);
extern int32 daafds_(int huge *dfile, char huge *desc, int huge *desclen);
extern int32 dagfidl_(int huge *dfile, int huge *isfirst);
extern int32 dagfdsl_(int huge *dfile, int huge *isfirst);
extern int32 dagfid_(int huge *dfile, char huge *id, int huge *maxlen,
		    int huge *isfirst);
extern int32 dagfds_(int huge *dfile, char huge *id, int huge *maxlen,
		    int huge *isfirst);
extern int32 daiafid_(int huge *dfile, char huge *id, int huge *idlen);

#else /* __STDC__ && !PC */

#if defined c_plusplus || defined __cplusplus
extern "C" {
#endif /* c_plusplus || __cplusplus */

/* prototypes for dfan.c */

extern int32 DFANgetlablen(char *filename, uint16 tag, uint16 ref);
extern int DFANgetlabel(char *filename, uint16 tag, uint16 ref, char *label,
			int32 maxlen);
extern int32 DFANgetdesclen(char *filename, uint16 tag, uint16 ref);
extern int DFANgetdesc(char *filename, uint16 tag, uint16 ref, char *desc,
		       int32 maxlen);
extern int32 DFANgetfidlen(DF *dfile, int isfirst);
extern int32 DFANgetfid(DF *dfile, char *id, int maxlen, int isfirst);
extern int32 DFANgetfdslen(DF *dfile, int isfirst);
extern int32 DFANgetfds(DF *dfile, char *desc, int maxlen, int isfirst);
extern int DFANputlabel(char *filename, uint16 tag, uint16 ref, char *label);
extern int DFANputdesc(char *filename, uint16 tag, uint16 ref, char *desc,
		       int32 desclen);
extern int DFANaddfid(DF *dfile, char *id);
extern int DFANaddfds(DF *dfile, char *desc, int32 desclen);
extern int DFANlastref(void);
extern int DFANlablist(char *filename, uint16 tag, uint16 reflist[],
		       char *labellist, int listsize, int maxlen, int startpos);
extern DF *DFANIopen(char *filename, int access);
extern int DFANIlocate(DF *dfile, int type, uint16 tag, uint16 ref);
extern int DFANIaddentry(int type, uint16 annref, uint16 datatag,
			 uint16 dataref);
extern int32 DFANIgetannlen(char *filename, uint16 tag, uint16 ref, int type);
extern int DFANIgetann(char *filename, uint16 tag, uint16 ref, char *ann,
		       int32 maxlen, int type);
extern int DFANIputann(char *filename, uint16 tag, uint16 ref, char *ann,
		       int32 annlen, int type);
extern int DFANIlablist(char *filename, uint16 tag, uint16 reflist[],
			char *labellist, int listsize, int maxlen, int startpos,
			int isfortran);
extern int32 DFANIgetfannlen(DF *dfile, int type, int isfirst);
extern int32 DFANIgetfann(DF *dfile, char *ann, int32 maxlen, int type,
			  int isfirst);
extern int DFANIaddfann(DF *dfile, char *ann, int32 annlen, int type);


/* prototypes for dfanF.c */

extern int32 daiganl_(char *filename, int *tag, int *ref, int *type,
		      int *fnlen);
extern int32 daigann_(char *filename, int *tag, int *ref, char *annotation,
		      int *maxlen, int *type, int *fnlen);
extern int32 daipann_(char *filename, int *tag, int *ref, char *annotation,
		      int *annlen, int *type, int *fnlen);
extern int dailist_(char *filename, int *tag, int *reflist, char *labellist,
		    int *listsize, int *maxlen, int *startpos, int *fnlen);
extern int dalref_(void);
extern int dfanlastref_(void);
extern int32 dfanaddfds_(int *dfile, char *desc, int *desclen);
extern int32 dfangetfidlen_(int *dfile, int *isfirst);
extern int32 dfangetfdslen_(int *dfile, int *isfirst);
extern int32 dfangetfid_(int *dfile, char *id, int *maxlen, int *isfirst);
extern int32 dfangetfds_(int *dfile, char *id, int *maxlen, int *isfirst);
extern int32 daafds_(int *dfile, char *desc, int *desclen);
extern int32 dagfidl_(int *dfile, int *isfirst);
extern int32 dagfdsl_(int *dfile, int *isfirst);
extern int32 dagfid_(int *dfile, char *id, int *maxlen, int *isfirst);
extern int32 dagfds_(int *dfile, char *id, int *maxlen, int *isfirst);
extern int32 daiafid_(int *dfile, char *id, int *idlen);

#if defined c_plusplus || defined __cplusplus
}
#endif /* c_plusplus || __cplusplus */

#endif /* PC */

#else /* !__STDC__ */

/* prototypes for dfan.c */

extern int32 DFANgetlablen();
extern int DFANgetlabel();
extern int32 DFANgetdesclen();
extern int DFANgetdesc();
extern int32 DFANgetfidlen();
extern int32 DFANgetfid();
extern int32 DFANgetfdslen();
extern int32 DFANgetfds();
extern int DFANputlabel();
extern int DFANputdesc();
extern int DFANaddfid();
extern int DFANaddfds();
extern int DFANlastref();
extern int DFANlablist();
extern DF *DFANIopen();
extern int DFANIlocate();
extern int DFANIaddentry();
extern int32 DFANIgetannlen();
extern int DFANIgetann();
extern int DFANIputann();
extern int DFANIlablist();
extern int32 DFANIgetfannlen();
extern int32 DFANIgetfann();
extern int DFANIaddfann();


/* prototypes for dfanF.c */

extern int32 daiganl_();
extern int32 daigann_();
extern int32 daipann_();
extern int dailist_();
extern int dalref_();
extern int dfanlastref_();
extern int32 dfanaddfds_();
extern int32 dfangetfidlen_();
extern int32 dfangetfdslen_();
extern int32 dfangetfid_();
extern int32 dfangetfds_();
extern int32 daafds_();
extern int32 dagfidl_();
extern int32 dagfdsl_();
extern int32 dagfid_();
extern int32 dagfds_();
extern int32 daiafid_();

#endif /* __STDC__ */

#endif /*DFAN*/
