SET i Osakkeet / RAUTA, SOFTA, VIIHDE, KIINTKORKO /;
ALIAS (i,j);

SCALAR Tavoite Keskim. vuosittainen tuotto (%) / 10 /;
PARAMETER Keskim(i) Keskim. vuosittainen tuotto (%)
     / RAUTA 8, SOFTA 9, VIIHDE 12, KIINTKORKO 7 /;

TABLE v(i,j) Varianssit ja kovarianssit
                RAUTA   SOFTA   VIIHDE   KIINTKORKO
  RAUTA           4       3       -1         0
  SOFTA           3       6        1         0
  VIIHDE         -1       1       10         0
  KIINTKORKO      0       0        0         0

POSITIVE VARIABLE x(i) Kohteeseen i sijoitettu osuus;
VARIABLE Varianssi Osakesalkun varianssi;

EQUATIONS Sijsumma, Keskituot, Vareq;
Sijsumma.. SUM(i, x(i)) =E= 1.0;
Keskituot.. SUM(i, Keskim(i)*x(i)) =G= Tavoite;
Vareq.. SUM(i, x(i)*SUM(j, v(i,j)*x(j))) =E= Varianssi;

MODEL Osakkeet / ALL /;
SOLVE Osakkeet USING NLP MINIMIZING Varianssi;
