PROGRAM IMSL_test
  IMPLICIT NONE
  INTEGER :: n, i, maxfcn
  REAL :: ftol, fx, s
  REAL, DIMENSION(:), ALLOCATABLE ::x, x0
  EXTERNAL fcn, umpol

  n = 2
  ALLOCATE(x(n), x0(n))
  x0(1:n-1:2) = -1.2d0
  x0(2:n:2) = 1.0d0

  ftol = 1.0d-10
  maxfcn = 1000*n**2
  s = 1.0

  CALL umpol(fcn, n, x0, s, ftol, maxfcn, x, fx)

  WRITE(*,*) 'x = ', x
  WRITE(*,*) 'fx = ', fx, '; iter = ', maxfcn
END PROGRAM IMSL_test

SUBROUTINE fcn(n, x, f)
  ! Minimoitava funktio
  IMPLICIT NONE
  INTEGER, INTENT(IN) :: n
  REAL, DIMENSION(n), INTENT(IN) :: x
  REAL, INTENT(OUT) :: f
  INTEGER :: i
  REAL ::  t1, t2
  f = 0.d0
  DO i = 1, n-1, 2
    t1 = 1.d0 - x(i); t2 = 10.d0*(x(i+1) - x(i)**2)
    ! Kohdefunktion arvo
    f = f + t1**2 + t2**2
  END DO
END SUBROUTINE fcn
