function [x,y] = gaDecode(popul)
% Lasketaan alkioiden ja kromosomien lkm
[npop bits] = size(popul); 
bits = bits/2;
% Haetaan alkioiden x- ja y-komponentit
xv = popul(:,1:bits); 
yv = popul(:,(bits+1):(2*bits));
% Muutetaan binriluvut reaaliluvuiksi
code = 2.^(0:(bits-1));   
r = 3.0; 
s = 2*r/(2^bits-1);
for i = 1:npop
  x(i) = s*sum(xv(i,1:bits).*code) - r;
  y(i) = s*sum(yv(i,1:bits).*code) - r;
end
