SETS nh Ravintoaineet ja hinta / ENERGIA kCal, PROTEIINIT g, 
                    KALSIUM mg, HINTA mk, MAXANNOS kpl /
     n(nh) Ravintoaineet / ENERGIA, PROTEIINIT, KALSIUM /
     r Ruokalajit / KAURAPUURO, KANA, KANANMUNAT, MAITO, 
                    PIIRAKKA, HERNEKEITT /;

PARAMETER b(n) Alarajat / ENERGIA 2000, PROTEIINIT 55, 
                         KALSIUM 800 /;
TABLE a(r,nh) Ruokalajien sisaltamat ravintoaineet ja hinta
              ENERGIA  PROTEIINIT  KALSIUM   HINTA  MAXANNOS
*              kcal        g         mg       mk      kpl
KAURAPUURO     110.0      4.0        2.0      1.0     4.0
KANA           205.0     32.0       12.0      8.0     3.0
KANANMUNAT     160.0     13.0       54.0      4.0     2.0
MAITO          160.0      8.0      285.0      3.0     8.0
PIIRAKKA       420.0      4.0       22.0      7.0     2.0
HERNEKEITT     260.0     14.0       80.0      6.0     2.0

POSITIVE VARIABLE x(r) Paivittaisen ruoan maara annoksina;
FREE VARIABLE Kustannus Ruoan kokonaishinta;

EQUATIONS nb(n), cb;

nb(n).. SUM(r, a(r,n)*x(r)) =G= b(n);  
cb..    Kustannus =E= SUM(r, a(r,'HINTA')*x(r));
x.up(r) = a(r,'MAXANNOS');

MODEL Dieetti / nb, cb /;  
SOLVE Dieetti MINIMIZING Kustannus USING LP;
