with(linalg):

# Lasketaan vektoriarvoiselle funktiolle 
#   Jacobin matriisi ja divergenssi
x := vector(2);
F := vector([ cos(x[1]*x[2]), sin(x[1]+x[2])]);
jac := jacobian(F,x);
div := diverge(F,x);

# Skalaariarvoisen funktion gradientti, Laplace-operaattori
#   ja Hessen matriisi
f := (x[1]**3)*(2 + x[2]**2);
gradientti := grad(f,x);
lap := diverge(grad(f,x),x);
hesse := hessian(f,x);
