SETS NH ravintoaineet ja hinta / ENERGIA kCAl, PROTEIINIT g, 
                                 KALSIUM mg, HINTA mk, MAXANNOS kpl /
     N(NH) ravintoaineet / ENERGIA, PROTEIINIT, KALSIUM /
     R ruokalajit / KAURAPUURO, KANA, KANANMUNAT, MAITO, PIIRAKKA, 
                    HERNEKEITT /;

PARAMETER B(N) minimit / ENERGIA 2000, PROTEIINIT 55, KALSIUM 800 /;

TABLE A(R,NH) ruokalajien sisaltamat ravintoaineet ja hinta

              ENERGIA  PROTEIINIT  KALSIUM   HINTA  MAXANNOS
*              kCal        g         mg       mk      kpl
KAURAPUURO     110.0      4.0        2.0      1.0     4.0
KANA           205.0     32.0       12.0      8.0     3.0
KANANMUNAT     160.0     13.0       54.0      4.0     2.0
MAITO          160.0      8.0      285.0      3.0     8.0
PIIRAKKA       420.0      4.0       22.0      7.0     2.0
HERNEKEITT     260.0     14.0       80.0      6.0     2.0

POSITIVE VARIABLE X(R) paivittaisen ruoan maara annoksina;
FREE VARIABLE KUSTANNUS ruoan kokonaishinta;

EQUATIONS NB(N) ravintoaineiden tasapainoyhtalo
          CB ruoan kokonaishinta;

NB(N).. SUM(R, A(R,N)*X(R)) =G= B(N);  
CB..    KUSTANNUS =E= SUM(R, A(R,'HINTA')*X(R));

X.UP(R) = A(R,'MAXANNOS');

MODEL DIEETTI / NB, CB /;  
SOLVE DIEETTI MINIMIZING KUSTANNUS USING LP;
