      implicit none
      integer n, i, maxfcn, nout
      parameter (n = 2)
      real ftol, fx, s, x(n), x0(n)
      external fcn, umpol, umach
c
      do i = 1, n-1, 2
         x0(i) = -1.2d0
         x0(i+1) = 1.0d0
      end do
c
      ftol = 1.0d-10
      maxfcn = 1000*n**2
      s = 1.0
c
      call umpol(fcn, n, x0, s, ftol, maxfcn, x, fx)
c
      call umach(2, nout)
      write (nout, 998) (x(i), i=1,n)
      write (nout, 999) fx, maxfcn
 998  format ('x =  ', 8(2x,f10.6))
 999  format ('fx =   ', f10.6, ', iter = ', i4)
c
      end
c                             Minimoitava funktio
      subroutine fcn(n, x, f)
      implicit none
      integer n, j
      real x(n), f, t1, t2
      f = 0.d0
      do 10 j = 1, n-1, 2
         t1 = 1.d0 - x(j)
         t2 = 10.d0 * ( x(j+1) - x(j)**2 )
         f = f + (t1**2) + (t2**2)
 10   continue
      return
      end
