/* ignpoi.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

integer ignpoi_(mu)
real *mu;
{
    /* Initialized data */

    static real muprev = (float)0.;
    static real a7 = (float).125006;
    static real fact[10] = { (float)1.,(float)1.,(float)2.,(float)6.,(float)
	    24.,(float)120.,(float)720.,(float)5040.,(float)40320.,(float)
	    362880. };
    static real muold = (float)0.;
    static real a0 = (float)-.5;
    static real a1 = (float).3333333;
    static real a2 = (float)-.2500068;
    static real a3 = (float).2000118;
    static real a4 = (float)-.1661269;
    static real a5 = (float).1421878;
    static real a6 = (float)-.1384794;

    /* System generated locals */
    integer ret_val, i__1, i__2;

    /* Builtin functions */
    double sqrt(), exp(), r_sign(), pow_ri(), log();

    /* Local variables */
    extern real ranf_();
    static real c, d, e, g;
    static integer j, k, l, m;
    static real p, q, s, t, u, v;
    static integer kflag;
    static real omega, x, b1, b2, c0, c1, c2, c3;
    extern real sexpo_();
    static real p0;
    extern real snorm_();
    static real fk, fx, fy, pp[35], px, py, difmuk, xx, del;

/* ********************************************************************** 
*/

/*     INTEGER FUNCTION IGNPOI( AV ) */

/*                    GENerate POIsson random deviate */


/*                              Function */


/*     Generates a single random deviate from a Poisson */
/*     distribution with mean AV. */


/*                              Arguments */


/*     AV --> The mean of the Poisson distribution from which */
/*            a random deviate is to be generated. */
/*                              REAL AV */

/*     GENEXP <-- The random deviate. */
/*                              REAL GENEXP */


/*                              Method */


/*     Renames KPOIS from TOMS as slightly modified by BWB to use RANF */
/*     instead of SUNIF. */

/*     For details see: */

/*               Ahrens, J.H. and Dieter, U. */
/*               Computer Generation of Poisson Deviates */
/*               From Modified Normal Distributions. */
/*               ACM Trans. Math. Software, 8, 2 */
/*               (June 1982),163-179 */

/* ********************************************************************** 
*/
/* **********************************************************************C
 */
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*                                                                      C 
*/
/*     P O I S S O N  DISTRIBUTION                                      C 
*/
/*                                                                      C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */
/* **********************************************************************C
 */
/*                                                                      C 
*/
/*     FOR DETAILS SEE:                                                 C 
*/
/*                                                                      C 
*/
/*               AHRENS, J.H. AND DIETER, U.                            C 
*/
/*               COMPUTER GENERATION OF POISSON DEVIATES                C 
*/
/*               FROM MODIFIED NORMAL DISTRIBUTIONS.                    C 
*/
/*               ACM TRANS. MATH. SOFTWARE, 8,2 (JUNE 1982), 163 - 179. C 
*/
/*                                                                      C 
*/
/*     (SLIGHTLY MODIFIED VERSION OF THE PROGRAM IN THE ABOVE ARTICLE)  C 
*/
/*                                                                      C 
*/
/* **********************************************************************C
 */

/*      INTEGER FUNCTION IGNPOI(IR,MU) */

/*     INPUT:  IR=CURRENT STATE OF BASIC RANDOM NUMBER GENERATOR */
/*             MU=MEAN MU OF THE POISSON DISTRIBUTION */
/*     OUTPUT: IGNPOI=SAMPLE FROM THE POISSON-(MU)-DISTRIBUTION */



/*     MUPREV=PREVIOUS MU, MUOLD=MU AT LAST EXECUTION OF STEP P OR B. */
/*     TABLES: COEFFICIENTS A0-A7 FOR STEP F. FACTORIALS FACT */
/*     COEFFICIENTS A(K) - FOR PX = FK*V*V*SUM(A(K)*V**K)-DEL */



/*     SEPARATION OF CASES A AND B */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. Local Arrays .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Data statements .. */
/*     .. */
/*     .. Executable Statements .. */
    if (*mu == muprev) {
	goto L10;
    }
    if (*mu < (float)10.) {
	goto L120;
    }

/*     C A S E  A. (RECALCULATION OF S,D,L IF MU HAS CHANGED) */

    muprev = *mu;
    s = sqrt(*mu);
    d = *mu * (float)6. * *mu;

/*             THE POISSON PROBABILITIES PK EXCEED THE DISCRETE NORMAL */
/*             PROBABILITIES FK WHENEVER K >= M(MU). L=IFIX(MU-1.1484) */
/*             IS AN UPPER BOUND TO M(MU) FOR ALL MU >= 10 . */

    l = (integer) (*mu - (float)1.1484);

/*     STEP N. NORMAL SAMPLE - SNORM(IR) FOR STANDARD NORMAL DEVIATE */

L10:
    g = *mu + s * snorm_();
    if (g < (float)0.) {
	goto L20;
    }
    ret_val = (integer) g;

/*     STEP I. IMMEDIATE ACCEPTANCE IF IGNPOI IS LARGE ENOUGH */

    if (ret_val >= l) {
	return ret_val;
    }

/*     STEP S. SQUEEZE ACCEPTANCE - SUNIF(IR) FOR (0,1)-SAMPLE U */

    fk = (real) ret_val;
    difmuk = *mu - fk;
    u = ranf_();
    if (d * u >= difmuk * difmuk * difmuk) {
	return ret_val;
    }

/*     STEP P. PREPARATIONS FOR STEPS Q AND H. */
/*             (RECALCULATIONS OF PARAMETERS IF NECESSARY) */
/*             .3989423=(2*PI)**(-.5)  .416667E-1=1./24.  .1428571=1./7. 
*/
/*             THE QUANTITIES B1, B2, C3, C2, C1, C0 ARE FOR THE HERMITE 
*/
/*             APPROXIMATIONS TO THE DISCRETE NORMAL PROBABILITIES FK. */
/*             C=.1069/MU GUARANTEES MAJORIZATION BY THE 'HAT'-FUNCTION. 
*/

L20:
    if (*mu == muold) {
	goto L30;
    }
    muold = *mu;
    omega = (float).3989423 / s;
    b1 = (float).04166667 / *mu;
    b2 = b1 * (float).3 * b1;
    c3 = b1 * (float).1428571 * b2;
    c2 = b2 - c3 * (float)15.;
    c1 = b1 - b2 * (float)6. + c3 * (float)45.;
    c0 = (float)1. - b1 + b2 * (float)3. - c3 * (float)15.;
    c = (float).1069 / *mu;
L30:
    if (g < (float)0.) {
	goto L50;
    }

/*             'SUBROUTINE' F IS CALLED (KFLAG=0 FOR CORRECT RETURN) */

    kflag = 0;
    goto L70;

/*     STEP Q. QUOTIENT ACCEPTANCE (RARE CASE) */

L40:
    if (fy - u * fy <= py * exp(px - fx)) {
	return ret_val;
    }

/*     STEP E. EXPONENTIAL SAMPLE - SEXPO(IR) FOR STANDARD EXPONENTIAL */
/*             DEVIATE E AND SAMPLE T FROM THE LAPLACE 'HAT' */
/*             (IF T <= -.6744 THEN PK < FK FOR ALL MU >= 10.) */

L50:
    e = sexpo_();
    u = ranf_();
    u = u + u - (float)1.;
    t = r_sign(&e, &u) + (float)1.8;
    if (t <= (float)-.6744) {
	goto L50;
    }
    ret_val = (integer) (*mu + s * t);
    fk = (real) ret_val;
    difmuk = *mu - fk;

/*             'SUBROUTINE' F IS CALLED (KFLAG=1 FOR CORRECT RETURN) */

    kflag = 1;
    goto L70;

/*     STEP H. HAT ACCEPTANCE (E IS REPEATED ON REJECTION) */

L60:
    if (c * abs(u) > py * exp(px + e) - fy * exp(fx + e)) {
	goto L50;
    }
    return ret_val;

/*     STEP F. 'SUBROUTINE' F. CALCULATION OF PX,PY,FX,FY. */
/*             CASE IGNPOI .LT. 10 USES FACTORIALS FROM TABLE FACT */

L70:
    if (ret_val >= 10) {
	goto L80;
    }
    px = -(*mu);
    py = pow_ri(mu, &ret_val) / fact[ret_val];
    goto L110;

/*             CASE IGNPOI .GE. 10 USES POLYNOMIAL APPROXIMATION */
/*             A0-A7 FOR ACCURACY WHEN ADVISABLE */
/*             .8333333E-1=1./12.  .3989423=(2*PI)**(-.5) */

L80:
    del = (float).08333333 / fk;
    del -= del * (float)4.8 * del * del;
    v = difmuk / fk;
    if (abs(v) <= (float).25) {
	goto L90;
    }
    px = fk * log(v + (float)1.) - difmuk - del;
    goto L100;
L90:
    px = fk * v * v * (((((((a7 * v + a6) * v + a5) * v + a4) * v + a3) * v + 
	    a2) * v + a1) * v + a0) - del;
L100:
    py = (float).3989423 / sqrt(fk);
L110:
    x = ((float).5 - difmuk) / s;
    xx = x * x;
    fx = xx * (float)-.5;
    fy = omega * (((c3 * xx + c2) * xx + c1) * xx + c0);
    if (kflag <= 0) {
	goto L40;
    } else {
	goto L60;
    }

/*     C A S E  B. (START NEW TABLE AND CALCULATE P0 IF NECESSARY) */

L120:
    muprev = (float)0.;
    if (*mu == muold) {
	goto L130;
    }
    muold = *mu;
/* Computing MAX */
    i__1 = 1, i__2 = (integer) (*mu);
    m = max(i__1,i__2);
    l = 0;
    p = exp(-(*mu));
    q = p;
    p0 = p;

/*     STEP U. UNIFORM SAMPLE FOR INVERSION METHOD */

L130:
    u = ranf_();
    ret_val = 0;
    if (u <= p0) {
	return ret_val;
    }

/*     STEP T. TABLE COMPARISON UNTIL THE END PP(L) OF THE */
/*             PP-TABLE OF CUMULATIVE POISSON PROBABILITIES */
/*             (0.458=PP(9) FOR MU=10) */

    if (l == 0) {
	goto L150;
    }
    j = 1;
    if (u > (float).458) {
	j = min(l,m);
    }
    i__1 = l;
    for (k = j; k <= i__1; ++k) {
	if (u <= pp[k - 1]) {
	    goto L180;
	}
/* L140: */
    }
    if (l == 35) {
	goto L130;
    }

/*     STEP C. CREATION OF NEW POISSON PROBABILITIES P */
/*             AND THEIR CUMULATIVES Q=PP(K) */

L150:
    ++l;
    for (k = l; k <= 35; ++k) {
	p = p * *mu / (real) k;
	q += p;
	pp[k - 1] = q;
	if (u <= q) {
	    goto L170;
	}
/* L160: */
    }
    l = 35;
    goto L130;
L170:
    l = k;
L180:
    ret_val = k;
    return ret_val;
} /* ignpoi_ */

