/* gennf.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__9 = 9;
static integer c__1 = 1;
static integer c__4 = 4;

real gennf_(dfn, dfd, xnonc)
real *dfn, *dfd, *xnonc;
{
    /* System generated locals */
    real ret_val;

    /* Builtin functions */
    integer s_wsle(), do_lio(), e_wsle();
    /* Subroutine */ int s_stop();

    /* Local variables */
    static real xden, xnum;
    static logical qcond;
    extern real genchi_(), gennch_();

    /* Fortran I/O blocks */
    static cilist io___2 = { 0, 6, 0, 0, 0 };
    static cilist io___3 = { 0, 6, 0, 0, 0 };
    static cilist io___4 = { 0, 6, 0, 0, 0 };
    static cilist io___5 = { 0, 6, 0, 0, 0 };
    static cilist io___8 = { 0, 6, 0, 0, 0 };
    static cilist io___9 = { 0, 6, 0, 0, 0 };
    static cilist io___10 = { 0, 6, 0, 0, 0 };


/* ********************************************************************** 
*/

/*     REAL FUNCTION GENNF( DFN, DFD, XNONC ) */
/*           GENerate random deviate from the Noncentral F distribution */


/*                              Function */


/*     Generates a random deviate from the  noncentral F (variance ratio) 
*/
/*     distribution with DFN degrees of freedom in the numerator, and DFD 
*/
/*     degrees of freedom in the denominator, and noncentrality parameter 
*/
/*     XNONC. */


/*                              Arguments */


/*     DFN --> Numerator degrees of freedom */
/*             (Must be >= 1.0) */
/*                              REAL DFN */
/*      DFD --> Denominator degrees of freedom */
/*             (Must be positive) */
/*                              REAL DFD */

/*     XNONC --> Noncentrality parameter */
/*               (Must be nonnegative) */
/*                              REAL XNONC */


/*                              Method */


/*     Directly generates ratio of noncentral numerator chisquare variate 
*/
/*     to central denominator chisquare variate. */

/* ********************************************************************** 
*/
/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Executable Statements .. */
    qcond = *dfn <= (float)1. || *dfd <= (float)0. || *xnonc < (float)0.;
    if (! qcond) {
	goto L10;
    }
    s_wsle(&io___2);
    do_lio(&c__9, &c__1, "In GENNF - Either (1) Numerator DF <= 1.0 or", 44L);
    e_wsle();
    s_wsle(&io___3);
    do_lio(&c__9, &c__1, "(2) Denominator DF < 0.0 or ", 28L);
    e_wsle();
    s_wsle(&io___4);
    do_lio(&c__9, &c__1, "(3) Noncentrality parameter < 0.0", 33L);
    e_wsle();
    s_wsle(&io___5);
    do_lio(&c__9, &c__1, "DFN value: ", 11L);
    do_lio(&c__4, &c__1, (char *)&(*dfn), (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, "DFD value: ", 11L);
    do_lio(&c__4, &c__1, (char *)&(*dfd), (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, "XNONC value: ", 13L);
    do_lio(&c__4, &c__1, (char *)&(*xnonc), (ftnlen)sizeof(real));
    e_wsle();
    s_stop("Degrees of freedom or noncent param our of range in GENNF", 57L);
L10:
    xnum = gennch_(dfn, xnonc) / *dfn;
/*      GENNF = ( GENNCH( DFN, XNONC ) / DFN ) / ( GENCHI( DFD ) / DFD ) 
*/
    xden = genchi_(dfd) / *dfd;
    if (! (xden <= xnum * (float)1e-38)) {
	goto L20;
    }
    s_wsle(&io___8);
    do_lio(&c__9, &c__1, " GENNF - generated numbers would cause overflow", 
	    47L);
    e_wsle();
    s_wsle(&io___9);
    do_lio(&c__9, &c__1, " Numerator ", 11L);
    do_lio(&c__4, &c__1, (char *)&xnum, (ftnlen)sizeof(real));
    do_lio(&c__9, &c__1, " Denominator ", 13L);
    do_lio(&c__4, &c__1, (char *)&xden, (ftnlen)sizeof(real));
    e_wsle();
    s_wsle(&io___10);
    do_lio(&c__9, &c__1, " GENNF returning 1.0E38", 23L);
    e_wsle();
    ret_val = (float)1e38;
    goto L30;
L20:
    ret_val = xnum / xden;
L30:
    return ret_val;
} /* gennf_ */

