/* genmn.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Subroutine */ int genmn_(parm, x, work)
real *parm, *x, *work;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Local variables */
    static integer i, j, p;
    extern real snorm_();
    static real ae;
    static integer icount;

/* ********************************************************************** 
*/

/*     SUBROUTINE GENMN(PARM,X,WORK) */
/*              GENerate Multivariate Normal random deviate */


/*                              Arguments */


/*     PARM --> Parameters needed to generate multivariate normal */
/*               deviates (MEANV and Cholesky decomposition of */
/*               COVM). Set by a previous call to SETGMN. */
/*               1 : 1                - size of deviate, P */
/*               2 : P + 1            - mean vector */
/*               P+2 : P*(P+3)/2 + 1  - upper half of cholesky */
/*                                       decomposition of cov matrix */
/*                                             REAL PARM(*) */

/*     X    <-- Vector deviate generated. */
/*                                             REAL X(P) */

/*     WORK <--> Scratch array */
/*                                             REAL WORK(P) */


/*                              Method */


/*     1) Generate P independent standard normal deviates - Ei ~ N(0,1) */

/*     2) Using Cholesky decomposition find A s.t. trans(A)*A = COVM */

/*     3) trans(A)E + MEANV ~ N(MEANV,COVM) */

/* ********************************************************************** 
*/
/*     .. Array Arguments .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */
    /* Parameter adjustments */
    --work;
    --x;
    --parm;

    /* Function Body */
    p = (integer) parm[1];

/*     Generate P independent normal deviates - WORK ~ N(0,1) */

    i__1 = p;
    for (i = 1; i <= i__1; ++i) {
	work[i] = snorm_();
/* L10: */
    }
    i__1 = p;
    for (i = 1; i <= i__1; ++i) {

/*     PARM (P+2 : P*(P+3)/2 + 1) contains A, the Cholesky */
/*      decomposition of the desired covariance matrix. */
/*          trans(A)(1,1) = PARM(P+2) */
/*          trans(A)(2,1) = PARM(P+3) */
/*          trans(A)(2,2) = PARM(P+2+P) */
/*          trans(A)(3,1) = PARM(P+4) */
/*          trans(A)(3,2) = PARM(P+3+P) */
/*          trans(A)(3,3) = PARM(P+2-1+2P)  ... */

/*     trans(A)*WORK + MEANV ~ N(MEANV,COVM) */

	icount = 0;
	ae = (float)0.;
	i__2 = i;
	for (j = 1; j <= i__2; ++j) {
	    icount = icount + j - 1;
	    ae += parm[i + (j - 1) * p - icount + p + 1] * work[j];
/* L20: */
	}
	x[i] = ae + parm[i + 1];
/* L30: */
    }
    return 0;

} /* genmn_ */

