/* dsterf.f -- translated by f2c (version of 23 April 1993  18:34:30).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static doublereal c_b14 = 1.;

/* Subroutine */ int dsterf_(n, d, e, info)
integer *n;
doublereal *d, *e;
integer *info;
{
    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(), d_sign();

    /* Local variables */
    static doublereal oldc;
    static integer lend, jtot;
    extern /* Subroutine */ int dlae2_();
    static doublereal c;
    static integer i, j, k, l, m;
    static doublereal p, gamma, r, s, alpha, sigma;
    static integer l1, lendm1, lendp1;
    extern doublereal dlapy2_();
    static doublereal bb;
    static integer ii;
    extern doublereal dlamch_();
    static doublereal oldgam;
    extern /* Subroutine */ int xerbla_();
    static integer nmaxit, lm1, mm1, nm1;
    static doublereal rt1, rt2, eps, rte, tst;


/*  -- LAPACK routine (version 1.1) -- */
/*     Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd., */
/*     Courant Institute, Argonne National Lab, and Rice University */
/*     March 31, 1993 */

/*     .. Scalar Arguments .. */
/*     .. */
/*     .. Array Arguments .. */
/*     .. */

/*  Purpose */
/*  ======= */

/*  DSTERF computes all eigenvalues of a symmetric tridiagonal matrix */
/*  using the Pal-Walker-Kahan variant of the QL or QR algorithm. */

/*  Arguments */
/*  ========= */

/*  N       (input) INTEGER */
/*          The order of the matrix.  N >= 0. */

/*  D       (input/output) DOUBLE PRECISION array, dimension (N) */
/*          On entry, the n diagonal elements of the tridiagonal matrix. 
*/
/*          On exit, if INFO = 0, the eigenvalues in ascending order. */

/*  E       (input/output) DOUBLE PRECISION array, dimension (N-1) */
/*          On entry, the (n-1) subdiagonal elements of the tridiagonal */
/*          matrix. */
/*          On exit, E has been destroyed. */

/*  INFO    (output) INTEGER */
/*          = 0:  successful exit */
/*          < 0:  if INFO = -i, the i-th argument had an illegal value */
/*          > 0:  the algorithm failed to find all of the eigenvalues in 
*/
/*                a total of 30*N iterations; if INFO = i, then i */
/*                elements of E have not converged to zero. */

/*  ===================================================================== 
*/

/*     .. Parameters .. */
/*     .. */
/*     .. Local Scalars .. */
/*     .. */
/*     .. External Functions .. */
/*     .. */
/*     .. External Subroutines .. */
/*     .. */
/*     .. Intrinsic Functions .. */
/*     .. */
/*     .. Executable Statements .. */

/*     Test the input parameters. */

    /* Parameter adjustments */
    --e;
    --d;

    /* Function Body */
    *info = 0;

/*     Quick return if possible */

    if (*n < 0) {
	*info = -1;
	i__1 = -(*info);
	xerbla_("DSTERF", &i__1, 6L);
	return 0;
    }
    if (*n <= 1) {
	return 0;
    }

/*     Determine the unit roundoff for this environment. */

    eps = dlamch_("E", 1L);

/*     Compute the eigenvalues of the tridiagonal matrix. */

    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
/* Computing 2nd power */
	d__1 = e[i];
	e[i] = d__1 * d__1;
/* L10: */
    }

    nmaxit = *n * 30;
    sigma = 0.;
    jtot = 0;

/*     Determine where the matrix splits and choose QL or QR iteration */
/*     for each block, according to whether top or bottom diagonal */
/*     element is smaller. */

    l1 = 1;
    nm1 = *n - 1;

L20:
    if (l1 > *n) {
	goto L170;
    }
    if (l1 > 1) {
	e[l1 - 1] = 0.;
    }
    if (l1 <= nm1) {
	i__1 = nm1;
	for (m = l1; m <= i__1; ++m) {
	    tst = sqrt((d__1 = e[m], abs(d__1)));
	    if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m + 1], 
		    abs(d__2)))) {
		goto L40;
	    }
/* L30: */
	}
    }
    m = *n;

L40:
    l = l1;
    lend = m;
    if ((d__1 = d[lend], abs(d__1)) < (d__2 = d[l], abs(d__2))) {
	l = lend;
	lend = l1;
    }
    l1 = m + 1;

    if (lend >= l) {

/*        QL Iteration */

/*        Look for small subdiagonal element. */

L50:
	if (l != lend) {
	    lendm1 = lend - 1;
	    i__1 = lendm1;
	    for (m = l; m <= i__1; ++m) {
		tst = sqrt((d__1 = e[m], abs(d__1)));
		if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m + 1],
			 abs(d__2)))) {
		    goto L70;
		}
/* L60: */
	    }
	}

	m = lend;

L70:
	if (m < lend) {
	    e[m] = 0.;
	}
	p = d[l];
	if (m == l) {
	    goto L90;
	}

/*        If remaining matrix is 2 by 2, use DLAE2 to compute its */
/*        eigenvalues. */

	if (m == l + 1) {
	    rte = sqrt(e[l]);
	    dlae2_(&d[l], &rte, &d[l + 1], &rt1, &rt2);
	    d[l] = rt1;
	    d[l + 1] = rt2;
	    e[l] = 0.;
	    l += 2;
	    if (l <= lend) {
		goto L50;
	    }
	    goto L20;
	}

	if (jtot == nmaxit) {
	    goto L150;
	}
	++jtot;

/*        Form shift. */

	rte = sqrt(e[l]);
	sigma = (d[l + 1] - p) / (rte * 2.);
	r = dlapy2_(&sigma, &c_b14);
	sigma = p - rte / (sigma + d_sign(&r, &sigma));

	c = 1.;
	s = 0.;
	gamma = d[m] - sigma;
	p = gamma * gamma;

/*        Inner loop */

	mm1 = m - 1;
	i__1 = l;
	for (i = mm1; i >= i__1; --i) {
	    bb = e[i];
	    r = p + bb;
	    if (i != m - 1) {
		e[i + 1] = s * r;
	    }
	    oldc = c;
	    c = p / r;
	    s = bb / r;
	    oldgam = gamma;
	    alpha = d[i];
	    gamma = c * (alpha - sigma) - s * oldgam;
	    d[i + 1] = oldgam + (alpha - gamma);
	    if (c != 0.) {
		p = gamma * gamma / c;
	    } else {
		p = oldc * bb;
	    }
/* L80: */
	}

	e[l] = s * p;
	d[l] = sigma + gamma;
	goto L50;

/*        Eigenvalue found. */

L90:
	d[l] = p;

	++l;
	if (l <= lend) {
	    goto L50;
	}
	goto L20;

    } else {

/*        QR Iteration */

/*        Look for small superdiagonal element. */

L100:
	if (l != lend) {
	    lendp1 = lend + 1;
	    i__1 = lendp1;
	    for (m = l; m >= i__1; --m) {
		tst = sqrt((d__1 = e[m - 1], abs(d__1)));
		if (tst <= eps * ((d__1 = d[m], abs(d__1)) + (d__2 = d[m - 1],
			 abs(d__2)))) {
		    goto L120;
		}
/* L110: */
	    }
	}

	m = lend;

L120:
	if (m > lend) {
	    e[m - 1] = 0.;
	}
	p = d[l];
	if (m == l) {
	    goto L140;
	}

/*        If remaining matrix is 2 by 2, use DLAE2 to compute its */
/*        eigenvalues. */

	if (m == l - 1) {
	    rte = sqrt(e[l - 1]);
	    dlae2_(&d[l], &rte, &d[l - 1], &rt1, &rt2);
	    d[l] = rt1;
	    d[l - 1] = rt2;
	    e[l - 1] = 0.;
	    l += -2;
	    if (l >= lend) {
		goto L100;
	    }
	    goto L20;
	}

	if (jtot == nmaxit) {
	    goto L150;
	}
	++jtot;

/*        Form shift. */

	rte = sqrt(e[l - 1]);
	sigma = (d[l - 1] - p) / (rte * 2.);
	r = dlapy2_(&sigma, &c_b14);
	sigma = p - rte / (sigma + d_sign(&r, &sigma));

	c = 1.;
	s = 0.;
	gamma = d[m] - sigma;
	p = gamma * gamma;

/*        Inner loop */

	lm1 = l - 1;
	i__1 = lm1;
	for (i = m; i <= i__1; ++i) {
	    bb = e[i];
	    r = p + bb;
	    if (i != m) {
		e[i - 1] = s * r;
	    }
	    oldc = c;
	    c = p / r;
	    s = bb / r;
	    oldgam = gamma;
	    alpha = d[i + 1];
	    gamma = c * (alpha - sigma) - s * oldgam;
	    d[i] = oldgam + (alpha - gamma);
	    if (c != 0.) {
		p = gamma * gamma / c;
	    } else {
		p = oldc * bb;
	    }
/* L130: */
	}

	e[lm1] = s * p;
	d[l] = sigma + gamma;
	goto L100;

/*        Eigenvalue found. */

L140:
	d[l] = p;

	--l;
	if (l >= lend) {
	    goto L100;
	}
	goto L20;

    }

/*     Set error -- no convergence to an eigenvalue after a total */
/*     of N*MAXIT iterations. */

L150:
    i__1 = *n - 1;
    for (i = 1; i <= i__1; ++i) {
	if (e[i] != 0.) {
	    ++(*info);
	}
/* L160: */
    }
    return 0;

/*     Sort eigenvalues in increasing order. */

L170:
    i__1 = *n;
    for (ii = 2; ii <= i__1; ++ii) {
	i = ii - 1;
	k = i;
	p = d[i];
	i__2 = *n;
	for (j = ii; j <= i__2; ++j) {
	    if (d[j] < p) {
		k = j;
		p = d[j];
	    }
/* L180: */
	}
	if (k != i) {
	    d[k] = d[i];
	    d[i] = p;
	}
/* L190: */
    }

    return 0;

/*     End of DSTERF */

} /* dsterf_ */

