/* util.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef RLAB_UTIL_H
#define RLAB_UTIL_H

#include "rlab.h"
#include "list.h"
#include "listnode.h"
#include "scalar.h"
#include "matrix.h"

#include <stdio.h>
#include <setjmp.h>

extern set_progname _PROTO ((char *value));

extern void set_util_line_nos _PROTO ((int val));

/* Error and warning functions */
extern void error_1 _PROTO ((char *s, char *t));
extern void error_2 _PROTO ((char *s1, char *s2, char *t));
extern void error_3 _PROTO ((char *s1, char *s2, char *s3, char *t));
extern void warning_1 _PROTO ((char *s, char *t));
extern void warning_2 _PROTO ((char *s1, char *s2, char *t));
extern void warning_3 _PROTO ((char *s1, char *s2, char *s3, char *t));

extern jmp_buf *jmp_inc_buff _PROTO ((void));
extern jmp_buf *jmp_dec_buff _PROTO ((void));
extern int inc_buff _PROTO ((void));
extern int dec_buff _PROTO ((void));
extern int get_ijmp _PROTO ((void));

/* Functions for signal handling */
extern void intcatch _PROTO ((int));
extern void intcatch_wait _PROTO ((int));
extern void fpecatch _PROTO ((int));
extern void pipecatch _PROTO ((int));

extern char *cpstr _PROTO ((char *string));
extern char *cpnstr _PROTO ((char *string, int n));
extern char *cpstr_strip _PROTO ((char *string));
extern char *strappend _PROTO ((char *s1, char *s2));
extern double get_datum_value _PROTO ((Datum d, char *s));
extern Datum convert_const _PROTO ((Datum d));
extern Datum convert_to_scalar _PROTO ((Datum d));
extern double get_num_scalar_val _PROTO ((Datum d));
extern Datum convert_to_matrix_entity _PROTO ((Datum d));
extern Datum convert_to_matrix _PROTO ((Datum d));
extern Datum convert_to_matrix_d _PROTO ((Datum d));
extern Datum convert_all_to_matrix _PROTO ((Datum d));
extern Datum convert_all_to_matrix_d _PROTO ((Datum d));
extern Datum convert_to_rhs_matrix _PROTO ((Datum d));
extern Datum matrix_to_scalar _PROTO ((Datum d));

extern Matrix *btree_Print_What _PROTO ((Btree *));
extern Matrix *btree_Print_Who _PROTO ((Btree *));
extern Matrix *btree_members _PROTO ((Btree *));

extern Matrix *matrix_CreateFillSind _PROTO ((int nrow, int ncol));

extern VPTR call_rlab_script _PROTO ((char *fname,
				      Datum * args, int nargs));

extern char ** get_btree_node_names _PROTO ((ListNode *node, char **names);)

#endif /* RLAB_UTIL_H */
