/* scalar.h */

/*  This file is a part of RLaB ("Our"-LaB)
   Copyright (C) 1992, 1993  Ian R. Searle

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   See the file ./COPYING
   ********************************************************************** */

#ifndef SCALAR_H
#define SCALAR_H

#include "rlab.h"
#include "btree.h"
#include "complex.h"
#include <stdio.h>

struct _scalar
{
  int type;			/* Structure type, always SCALAR */
  char *name;			/* Name of data object */
  Complex val;
};

typedef struct _scalar Scalar;

extern Scalar *scalar_Create _PROTO ((double));
extern Scalar *scalar_CreateC _PROTO ((double vr, double vi));

extern Scalar *scalar_Copy _PROTO ((Scalar * s));
extern void scalar_Destroy _PROTO ((Scalar *));

extern void scalar_SetVal _PROTO ((Scalar *, double));
extern void scalar_SetValC _PROTO ((Scalar *, double vr, double vc));
extern void scalar_SetName _PROTO ((Scalar * s, char *name));

extern void scalar_Inc _PROTO ((Scalar * s));
extern void scalar_Dec _PROTO ((Scalar * s));

extern void scalar_Write _PROTO ((Scalar * s, FILE * fn));
extern Scalar *scalar_Read _PROTO ((FILE * fn));
extern void scalar_Print _PROTO ((Scalar * s, FILE * fn));

#define scalar_GetName(s)     (((Scalar *)(s))->name)
#define SVAL(s)               (((Scalar *)(s))->val)
#define SVALr(s)              (((Scalar *)(s))->val.r)
#define SVALi(s)              (((Scalar *)(s))->val.i)

#define min(a,b) ((a) <= (b) ? (a) : (b))
#define max(a,b) ((a) >= (b) ? (a) : (b))

#endif /* SCALAR_H */
